/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.platetectonics.model.PlateMotionModel;
import edu.colorado.phet.platetectonics.model.labels.BoundaryLabel;
import edu.colorado.phet.platetectonics.tabs.PlateMotionTab;
import edu.colorado.phet.platetectonics.util.MortalSimpleObserver;
import edu.colorado.phet.platetectonics.util.Side;
import edu.colorado.phet.platetectonics.view.PlateTectonicsView;
import edu.colorado.phet.platetectonics.view.SmokeNode;
import edu.colorado.phet.platetectonics.view.labels.BoundaryLabelNode;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateMotionView
extends PlateTectonicsView {
    public PlateMotionView(PlateMotionModel plateMotionModel, final PlateMotionTab plateMotionTab, Property<Boolean> property) {
        super(plateMotionModel, plateMotionTab, property);
        final SmokeNode smokeNode = new SmokeNode(plateMotionTab.getModelViewTransform(), plateMotionTab.getPlateMotionModel().smokePuffs);
        this.addChild(smokeNode);
        plateMotionModel.modelChanged.addListener(new VoidFunction1<Void>(){

            @Override
            public void apply(Void void_) {
                PlateMotionView.this.removeChild(smokeNode);
                PlateMotionView.this.addChild(smokeNode);
            }
        });
        PlateMotionModel plateMotionModel2 = plateMotionModel;
        plateMotionModel2.boundaryLabels.addElementAddedObserver(new VoidFunction1<BoundaryLabel>(){

            @Override
            public void apply(final BoundaryLabel boundaryLabel) {
                BoundaryLabelNode boundaryLabelNode = new BoundaryLabelNode(boundaryLabel, plateMotionTab.getModelViewTransform(), plateMotionTab.colorMode){
                    {
                        super(boundaryLabel3, lWJGLTransform, property);
                        final PlateMotionTab plateMotionTab = plateMotionTab;
                        plateMotionTab.showLabels.addObserver(new MortalSimpleObserver(plateMotionTab.showLabels, boundaryLabel.disposed){

                            public void update() {
                                this.setVisible(plateMotionTab.showLabels.get());
                            }
                        });
                    }
                };
                PlateMotionView.this.addChild(boundaryLabelNode);
                PlateMotionView.this.nodeMap.put(boundaryLabel, boundaryLabelNode);
            }
        });
        plateMotionModel2.boundaryLabels.addElementRemovedObserver(new VoidFunction1<BoundaryLabel>(){

            @Override
            public void apply(BoundaryLabel boundaryLabel) {
                PlateMotionView.this.removeChild((GLNode)PlateMotionView.this.nodeMap.get(boundaryLabel));
                PlateMotionView.this.nodeMap.remove(boundaryLabel);
            }
        });
        plateMotionModel2.frontBoundarySideNotifier.addListener(new VoidFunction1<Side>(){

            @Override
            public void apply(Side side) {
                for (GLNode gLNode : new ArrayList<GLNode>(PlateMotionView.this.getChildren())) {
                    if (!(gLNode instanceof BoundaryLabelNode) || ((BoundaryLabelNode)gLNode).getBoundaryLabel().side != side) continue;
                    PlateMotionView.this.removeChild(gLNode);
                    PlateMotionView.this.addChild(gLNode);
                }
            }
        });
    }
}

