/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.UnitMarker;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.regions.CrossSectionStrip;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.view.CrossSectionStripNode;
import edu.colorado.phet.platetectonics.view.TerrainNode;
import edu.colorado.phet.platetectonics.view.WaterStripNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateTectonicsView
extends GLNode {
    protected final Map<Object, GLNode> nodeMap = new HashMap<Object, GLNode>();
    protected final Map<CrossSectionStrip, UpdateListener> sortListenerMap = new HashMap<CrossSectionStrip, UpdateListener>();
    private final PlateTectonicsModel model;
    private final PlateTectonicsTab tab;
    private final Property<Boolean> showWater;

    public PlateTectonicsView(PlateTectonicsModel plateTectonicsModel, PlateTectonicsTab plateTectonicsTab) {
        this(plateTectonicsModel, plateTectonicsTab, new Property<Boolean>(true));
    }

    public PlateTectonicsView(PlateTectonicsModel plateTectonicsModel, final PlateTectonicsTab plateTectonicsTab, Property<Boolean> property) {
        this.model = plateTectonicsModel;
        this.tab = plateTectonicsTab;
        this.showWater = property;
        for (Terrain object : plateTectonicsModel.getTerrains()) {
            this.addTerrain(object);
        }
        for (CrossSectionStrip crossSectionStrip : plateTectonicsModel.getCrossSectionStrips()) {
            this.addCrossSectionStrip(crossSectionStrip);
        }
        plateTectonicsModel.crossSectionStripAdded.addListener(new VoidFunction1<CrossSectionStrip>(){

            @Override
            public void apply(CrossSectionStrip crossSectionStrip) {
                PlateTectonicsView.this.addCrossSectionStrip(crossSectionStrip);
            }
        });
        plateTectonicsModel.crossSectionStripRemoved.addListener(new VoidFunction1<CrossSectionStrip>(){

            @Override
            public void apply(CrossSectionStrip crossSectionStrip) {
                PlateTectonicsView.this.removeCrossSectionStrip(crossSectionStrip);
            }
        });
        plateTectonicsModel.terrainAdded.addListener(new VoidFunction1<Terrain>(){

            @Override
            public void apply(Terrain terrain) {
                PlateTectonicsView.this.addTerrain(terrain);
            }
        });
        plateTectonicsModel.terrainRemoved.addListener(new VoidFunction1<Terrain>(){

            @Override
            public void apply(Terrain terrain) {
                PlateTectonicsView.this.removeTerrain(terrain);
            }
        });
        plateTectonicsModel.debugPing.addListener(new VoidFunction1<Vector3F>(){

            @Override
            public void apply(final Vector3F vector3F) {
                PlateTectonicsView.this.addChild(new UnitMarker(){
                    {
                        Vector3F vector3F2 = plateTectonicsTab.getModelViewTransform().transformPosition(PlateTectonicsModel.convertToRadial(vector3F));
                        this.translate(vector3F2.x, vector3F2.y, vector3F2.z);
                        this.scale(3.0f);
                    }
                });
            }
        });
    }

    private void addCrossSectionStrip(final CrossSectionStrip crossSectionStrip) {
        this.addWrappedChild(crossSectionStrip, new CrossSectionStripNode(this.tab.getModelViewTransform(), this.tab.colorMode, crossSectionStrip));
        UpdateListener updateListener = new UpdateListener(){

            public void update() {
                GLNode gLNode = PlateTectonicsView.this.nodeMap.get(crossSectionStrip);
                if (gLNode != null && gLNode.getParent() != null) {
                    PlateTectonicsView.this.removeChild(gLNode);
                    PlateTectonicsView.this.addChild(gLNode);
                }
            }
        };
        crossSectionStrip.moveToFrontNotifier.addUpdateListener(updateListener, false);
        this.sortListenerMap.put(crossSectionStrip, updateListener);
    }

    private void removeCrossSectionStrip(CrossSectionStrip crossSectionStrip) {
        this.removeChild(this.nodeMap.get(crossSectionStrip));
        this.nodeMap.remove(crossSectionStrip);
        crossSectionStrip.moveToFrontNotifier.removeListener(this.sortListenerMap.get(crossSectionStrip));
    }

    private void addTerrain(final Terrain terrain) {
        this.addWrappedChild(terrain, new GLNode(){
            {
                TerrainNode terrainNode = new TerrainNode(terrain, PlateTectonicsView.this.tab.getModelViewTransform());
                this.addChild(terrainNode);
                if (terrain.hasWater()) {
                    final WaterStripNode waterStripNode = new WaterStripNode(terrain, PlateTectonicsView.this.model, PlateTectonicsView.this.tab);
                    final SimpleObserver simpleObserver = new SimpleObserver(){

                        public void update() {
                            if (((Boolean)PlateTectonicsView.this.showWater.get()).booleanValue() && terrain.isWaterValid.get().booleanValue()) {
                                this.addChild(waterStripNode);
                            } else if (waterStripNode.getParent() != null) {
                                this.removeChild(waterStripNode);
                            }
                        }
                    };
                    PlateTectonicsView.this.showWater.addObserver(simpleObserver);
                    terrain.isWaterValid.addObserver(simpleObserver);
                    terrain.disposed.addUpdateListener(new UpdateListener(){

                        public void update() {
                            PlateTectonicsView.this.showWater.removeObserver(simpleObserver);
                            terrain.isWaterValid.removeObserver(simpleObserver);
                        }
                    }, false);
                }
            }
        });
    }

    private void removeTerrain(Terrain terrain) {
        this.removeChild(this.nodeMap.get(terrain));
        this.nodeMap.remove(terrain);
    }

    public void addWrappedChild(Object object, GLNode gLNode) {
        assert (this.nodeMap.get(object) == null);
        this.addChild(gLNode);
        this.nodeMap.put(object, gLNode);
    }

    @Override
    protected void renderChildren(GLOptions gLOptions) {
        super.renderChildren(gLOptions);
        GLOptions gLOptions2 = gLOptions.getCopy();
        gLOptions2.renderPass = GLOptions.RenderPass.TRANSPARENCY;
        for (GLNode gLNode : new ArrayList<GLNode>(this.getChildren())) {
            gLNode.render(gLOptions2);
        }
    }
}

