/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.SmokePuff;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmokeNode
extends GLNode {
    private final Map<SmokePuff, SmokePuffNode> map = new HashMap<SmokePuff, SmokePuffNode>();
    private final LWJGLTransform modelViewTransform;

    public SmokeNode(LWJGLTransform lWJGLTransform, ObservableList<SmokePuff> observableList) {
        this.modelViewTransform = lWJGLTransform;
        observableList.addElementAddedObserver(new VoidFunction1<SmokePuff>(){

            @Override
            public void apply(SmokePuff smokePuff) {
                SmokeNode.this.addPuff(smokePuff);
            }
        });
        observableList.addElementRemovedObserver(new VoidFunction1<SmokePuff>(){

            @Override
            public void apply(SmokePuff smokePuff) {
                SmokeNode.this.removePuff(smokePuff);
            }
        });
        this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
    }

    private void addPuff(SmokePuff smokePuff) {
        SmokePuffNode smokePuffNode = new SmokePuffNode(this.modelViewTransform, smokePuff);
        this.addChild(smokePuffNode);
        this.map.put(smokePuff, smokePuffNode);
    }

    private void removePuff(SmokePuff smokePuff) {
        this.removeChild(this.map.get(smokePuff));
    }

    public static class SmokePuffNode
    extends GLNode {
        private static int NUM_SAMPLES = 80;
        private static FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((NUM_SAMPLES + 1) * 3);
        private final SmokePuff puff;

        public SmokePuffNode(final LWJGLTransform lWJGLTransform, final SmokePuff smokePuff) {
            this.puff = smokePuff;
            this.requireEnabled(3042);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    Vector3F vector3F = lWJGLTransform.transformPosition(PlateTectonicsModel.convertToRadial(smokePuff.position.get()));
                    SmokePuffNode.this.transform.set(Matrix4F.translation(vector3F.x, vector3F.y, vector3F.z).times(Matrix4F.scaling(smokePuff.scale.get().floatValue())));
                }
            };
            smokePuff.position.addObserver(simpleObserver);
            smokePuff.scale.addObserver(simpleObserver);
        }

        public void renderSelf(GLOptions gLOptions) {
            super.renderSelf(gLOptions);
            GL11.glColor4f(0.0f, 0.0f, 0.0f, this.puff.alpha.get().floatValue());
            GL11.glDepthMask(false);
            GL11.glEnableClientState(32884);
            positionBuffer.rewind();
            GL11.glVertexPointer(3, 0, positionBuffer);
            GL11.glDrawArrays(6, 0, NUM_SAMPLES + 1);
            GL11.glDisableClientState(32884);
            GL11.glDepthMask(true);
        }

        private static Vector2F computeCloudShape(float f) {
            float f2 = (float)(1.0 + Math.cos(20.0f * f) / 20.0);
            double d = 1.0 * Math.max(0.0, Math.cos(f));
            return new Vector2F((double)f2 * Math.cos(f) + d, Math.sin(f) * ((double)f2 - d * d)).minus(new Vector2F(2.0, 0.0));
        }

        static {
            positionBuffer.put(new float[]{0.0f, 2.0f, 0.0f});
            for (int i = 0; i < NUM_SAMPLES; ++i) {
                float f = (float)(Math.PI * 2 * (double)i / (double)(NUM_SAMPLES - 1));
                Vector2F vector2F = SmokePuffNode.computeCloudShape(f);
                positionBuffer.put(new float[]{vector2F.y, -vector2F.x, 0.0f});
            }
        }
    }
}

