/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.platetectonics.PlateTectonicsConstants;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.view.GridStripNode;
import edu.colorado.phet.platetectonics.view.materials.EarthTexture;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TerrainNode
extends GridStripNode {
    private final Terrain terrainStrip;
    private boolean textureRefreshNeeded = true;
    private FloatBuffer textureBuffer;
    private FloatBuffer colorBuffer;

    public TerrainNode(Terrain terrain, LWJGLTransform lWJGLTransform) {
        super(lWJGLTransform);
        this.terrainStrip = terrain;
        this.requireEnabled(2896);
        this.requireEnabled(2903);
        terrain.elevationChanged.addUpdateListener(new UpdateListener(){

            public void update() {
                TerrainNode.this.updatePosition();
            }
        }, true);
        terrain.columnsModified.addUpdateListener(new UpdateListener(){

            public void update() {
                TerrainNode.this.textureRefreshNeeded = true;
            }
        }, false);
    }

    public int getNumberOfVertices() {
        return this.terrainStrip.getNumberOfVertices();
    }

    public int getNumColumns() {
        return this.terrainStrip.getNumColumns();
    }

    public int getNumRows() {
        return this.terrainStrip.getNumRows();
    }

    public float getXPosition(int n) {
        return this.terrainStrip.xPositions.get(n).floatValue();
    }

    public float getZPosition(int n) {
        return this.terrainStrip.zPositions.get(n).floatValue();
    }

    public float getElevation(int n, int n2) {
        return this.terrainStrip.getSample(n, n2).getElevation();
    }

    public void setCapacity(int n) {
        super.setCapacity(n);
        this.textureBuffer = BufferUtils.createFloatBuffer(n * 2);
        this.colorBuffer = BufferUtils.createFloatBuffer(n * 4);
    }

    protected void updatePosition() {
        super.updatePosition();
        int n = this.terrainStrip.getNumColumns();
        int n2 = this.terrainStrip.getNumRows();
        if (this.textureRefreshNeeded) {
            this.textureRefreshNeeded = false;
            this.textureBuffer.clear();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    TerrainSample terrainSample = this.terrainStrip.getSample(j, i);
                    this.textureBuffer.put(new float[]{terrainSample.getTextureCoordinates().x, terrainSample.getTextureCoordinates().y});
                }
            }
        }
        this.colorBuffer.clear();
        float f = (float)PlateTectonicsConstants.EARTH_GREEN.getRed() / 255.0f;
        float f2 = (float)PlateTectonicsConstants.EARTH_GREEN.getGreen() / 255.0f;
        float f3 = (float)PlateTectonicsConstants.EARTH_GREEN.getBlue() / 255.0f;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f4;
                float f5 = this.terrainStrip.getSample(j, i).getElevation();
                if (f5 < 1000.0f) {
                    f4 = (float)MathUtil.clamp(0.0, (f5 + 7000.0f) / 10000.0f, 1.0);
                    if (f5 < -500.0f) {
                        this.colorBuffer.put(new float[]{f4, f4, f4, 1.0f});
                        continue;
                    }
                    float f6 = (float)MathUtil.clamp(0.0, -(f5 - 1000.0f) / 1500.0f, 1.0);
                    this.colorBuffer.put(new float[]{f4 * f6 + f * (1.0f - f6), f4 * f6 + f2 * (1.0f - f6), f4 * f6 + f3 * (1.0f - f6), 1.0f});
                    continue;
                }
                if (f5 < 3000.0f) {
                    this.colorBuffer.put(new float[]{f, f2, f3, 1.0f});
                    continue;
                }
                f4 = (f5 - 3000.0f) / 7000.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.colorBuffer.put(new float[]{f + (0.8f - f) * f4, f2 + (0.8f - f2) * f4, f3 + (0.8f - f3) * f4, 1.0f});
            }
        }
    }

    protected void preRender(GLOptions gLOptions) {
        super.preRender(gLOptions);
        this.textureBuffer.rewind();
        this.colorBuffer.rewind();
        GL11.glEnableClientState(32886);
        GL11.glColorMaterial(1028, 4609);
        GL11.glColorPointer(4, 0, this.colorBuffer);
        if (gLOptions.shouldSendTexture()) {
            GL11.glEnableClientState(32888);
            GL11.glTexCoordPointer(2, 0, this.textureBuffer);
        }
        EarthTexture.begin();
    }

    protected void postRender(GLOptions gLOptions) {
        super.postRender(gLOptions);
        EarthTexture.end();
        if (gLOptions.shouldSendTexture()) {
            GL11.glDisableClientState(32888);
        }
        GL11.glDisableClientState(32886);
    }
}

