/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.materials.ColorMaterial;
import edu.colorado.phet.lwjglphet.math.LWJGLTransform;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.platetectonics.model.PlateTectonicsModel;
import edu.colorado.phet.platetectonics.model.Terrain;
import edu.colorado.phet.platetectonics.model.TerrainSample;
import edu.colorado.phet.platetectonics.tabs.PlateTectonicsTab;
import edu.colorado.phet.platetectonics.util.MortalUpdateListener;
import edu.colorado.phet.platetectonics.view.GridStripNode;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class WaterStripNode
extends GLNode {
    private final Terrain terrain;
    private final PlateTectonicsModel model;
    private final PlateTectonicsTab module;

    public WaterStripNode(final Terrain terrain, PlateTectonicsModel plateTectonicsModel, PlateTectonicsTab plateTectonicsTab) {
        this.terrain = terrain;
        this.model = plateTectonicsModel;
        this.module = plateTectonicsTab;
        this.requireEnabled(3042);
        this.addChild(new WaterTopMesh(plateTectonicsTab.getModelViewTransform()){
            {
                super(lWJGLTransform);
                this.setMaterial(new ColorMaterial(0.2f, 0.5f, 0.8f, 0.5f));
                this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
                terrain.elevationChanged.addUpdateListener(new UpdateListener(){

                    public void update() {
                        this.updatePosition();
                    }
                }, true);
            }
        });
        this.addChild(new WaterFrontMesh(){
            {
                this.setMaterial(new ColorMaterial(0.1f, 0.3f, 0.7f, 0.5f));
                this.setRenderPass(GLOptions.RenderPass.TRANSPARENCY);
            }
        });
    }

    private class WaterFrontMesh
    extends GLNode {
        private FloatBuffer positionBuffer;
        private IntBuffer indexBuffer;
        private int capacity = 0;

        public WaterFrontMesh() {
            int n = WaterStripNode.this.terrain.getNumColumns() * 2;
            this.positionBuffer = BufferUtils.createFloatBuffer(n * 3);
            this.indexBuffer = BufferUtils.createIntBuffer(n);
            final Runnable runnable = new Runnable(){

                public void run() {
                    WaterFrontMesh.this.checkSize();
                    WaterFrontMesh.this.positionBuffer.clear();
                    WaterFrontMesh.this.indexBuffer.clear();
                    int n = WaterStripNode.this.terrain.getFrontZIndex();
                    int n2 = WaterStripNode.this.terrain.getNumColumns();
                    boolean bl = WaterStripNode.this.terrain.getSample(0, n).getElevation() >= 0.0f;
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n3 = 0;
                    float f3 = ((WaterStripNode)WaterStripNode.this).terrain.zPositions.get(WaterStripNode.this.terrain.getFrontZIndex()).floatValue();
                    for (int i = 0; i < n2; ++i) {
                        Vector3F vector3F;
                        float f4;
                        float f5 = ((WaterStripNode)WaterStripNode.this).terrain.xPositions.get(i).floatValue();
                        TerrainSample terrainSample = WaterStripNode.this.terrain.getSample(i, n);
                        float f6 = terrainSample.getElevation();
                        if (f6 >= 0.0f) {
                            if (!bl) {
                                f4 = f - f2 * (f5 - f) / (f6 - f2);
                                assert (f4 >= f);
                                assert (f4 <= f5);
                                vector3F = WaterStripNode.this.module.getModelViewTransform().transformPosition(f3 == 0.0f ? PlateTectonicsModel.convertToRadial(f4, 0.0f) : PlateTectonicsModel.convertToRadial(new Vector3F(f4, 0.0f, f3)));
                                WaterFrontMesh.this.positionBuffer.put(new float[]{vector3F.x, vector3F.y, vector3F.z, vector3F.x, vector3F.y, vector3F.z});
                                WaterFrontMesh.this.indexBuffer.put(n3++);
                                WaterFrontMesh.this.indexBuffer.put(n3++);
                            }
                        } else {
                            if (bl) {
                                f4 = f - f2 * (f5 - f) / (f6 - f2);
                                assert (f4 >= f);
                                assert (f4 <= f5);
                                vector3F = WaterStripNode.this.module.getModelViewTransform().transformPosition(f3 == 0.0f ? PlateTectonicsModel.convertToRadial(f4, 0.0f) : PlateTectonicsModel.convertToRadial(new Vector3F(f4, 0.0f, f3)));
                                WaterFrontMesh.this.positionBuffer.put(new float[]{vector3F.x, vector3F.y, vector3F.z, vector3F.x, vector3F.y, vector3F.z});
                                WaterFrontMesh.this.indexBuffer.put(n3++);
                                WaterFrontMesh.this.indexBuffer.put(n3++);
                            }
                            Vector3F vector3F2 = WaterStripNode.this.module.getModelViewTransform().transformPosition(f3 == 0.0f ? PlateTectonicsModel.convertToRadial(f5, 0.0f) : PlateTectonicsModel.convertToRadial(new Vector3F(f5, 0.0f, f3)));
                            vector3F = WaterStripNode.this.module.getModelViewTransform().transformPosition(f3 == 0.0f ? PlateTectonicsModel.convertToRadial(f5, f6) : PlateTectonicsModel.convertToRadial(new Vector3F(f5, f6, f3)));
                            WaterFrontMesh.this.positionBuffer.put(new float[]{vector3F2.x, vector3F2.y, vector3F2.z, vector3F.x, vector3F.y, vector3F.z});
                            WaterFrontMesh.this.indexBuffer.put(n3++);
                            WaterFrontMesh.this.indexBuffer.put(n3++);
                        }
                        f = f5;
                        f2 = f6;
                        bl = f6 >= 0.0f;
                    }
                    WaterFrontMesh.this.positionBuffer.limit(n3 * 3);
                    WaterFrontMesh.this.indexBuffer.limit(n3);
                }
            };
            runnable.run();
            ((WaterStripNode)WaterStripNode.this).model.modelChanged.addUpdateListener(new MortalUpdateListener(((WaterStripNode)WaterStripNode.this).model.modelChanged, ((WaterStripNode)WaterStripNode.this).terrain.disposed){

                public void update() {
                    runnable.run();
                }
            }, false);
        }

        private void checkSize() {
            int n = WaterStripNode.this.terrain.getNumColumns() * 3;
            if (this.capacity < n) {
                this.capacity = n;
                this.positionBuffer = BufferUtils.createFloatBuffer(n * 3);
                this.indexBuffer = BufferUtils.createIntBuffer(n);
            }
        }

        public void renderSelf(GLOptions gLOptions) {
            super.renderSelf(gLOptions);
            this.positionBuffer.rewind();
            this.indexBuffer.rewind();
            GL11.glEnableClientState(32884);
            GL11.glVertexPointer(3, 0, this.positionBuffer);
            GL11.glDrawElements(5, this.indexBuffer);
            GL11.glDisableClientState(32884);
        }
    }

    private class WaterTopMesh
    extends GridStripNode {
        public WaterTopMesh(LWJGLTransform lWJGLTransform) {
            super(lWJGLTransform);
            this.setComputeNormals(false);
        }

        public float getElevation(int n, int n2) {
            return 0.0f;
        }

        public int getNumberOfVertices() {
            return WaterStripNode.this.terrain.getNumberOfVertices();
        }

        public int getNumColumns() {
            return WaterStripNode.this.terrain.getNumColumns();
        }

        public int getNumRows() {
            return WaterStripNode.this.terrain.getNumRows();
        }

        public float getXPosition(int n) {
            return ((WaterStripNode)WaterStripNode.this).terrain.xPositions.get(n).floatValue();
        }

        public float getZPosition(int n) {
            return ((WaterStripNode)WaterStripNode.this).terrain.zPositions.get(n).floatValue();
        }
    }
}

