/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.materials;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.platetectonics.view.materials.EarthMaterial;
import java.awt.Color;

public class DensityMaterial
implements EarthMaterial {
    private static final Color min = new Color(255, 255, 255);
    private static final Color max = new Color(0, 0, 0);

    public static Vector2F densityMap(float f) {
        float f2;
        float f3 = 2500.0f;
        float f4 = 3500.0f;
        float f5 = 13100.0f;
        float f6 = (f - f3) / (f4 - f3);
        if (f <= 3300.0f) {
            f2 = 100.0f + (1.0f - f6) * 155.0f;
        } else {
            float f7 = 100.0f + (1.0f - (3300.0f - f3) / (f4 - f3)) * 155.0f;
            float f8 = 50.0f;
            float f9 = (f - 3300.0f) / (f5 - 3300.0f);
            f2 = f7 + (f8 - f7) * f9;
        }
        f2 = (float)MathUtil.clamp(0.0, f2 / 220.0f, 1.0);
        return new Vector2F(f2, 0.5f);
    }

    public Color getColor(float f, float f2, Vector2F vector2F, float f3) {
        float f4 = DensityMaterial.densityMap((float)f).x;
        return new Color(f4, f4, f4, f3);
    }

    public Color getMinColor() {
        return min;
    }

    public Color getMaxColor() {
        return max;
    }
}

