/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.materials;

import edu.colorado.phet.platetectonics.PlateTectonicsResources;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class EarthTexture {
    private static int textureId;
    private static boolean textureInitialized;
    private static ByteBuffer buffer;

    public static void begin() {
        GL11.glEnable(3553);
        if (!textureInitialized) {
            textureInitialized = true;
            textureId = GL11.glGenTextures();
            GL11.glBindTexture(3553, textureId);
            GL11.glTexEnvf(8960, 8704, 8448.0f);
            GL11.glTexParameterf(3553, 10241, 9985.0f);
            GL11.glTexParameterf(3553, 10240, 9729.0f);
            GL11.glTexParameterf(3553, 10242, 10497.0f);
            GL11.glTexParameterf(3553, 10243, 10497.0f);
            GLU.gluBuild2DMipmaps(3553, 4, 512, 512, 6408, 5121, buffer);
        }
        GL11.glBindTexture(3553, textureId);
    }

    public static void end() {
        GL11.glDisable(3553);
    }

    static {
        textureInitialized = false;
        buffer = BufferUtils.createByteBuffer(0x100000);
        try {
            BufferedImage bufferedImage = ImageIO.read(PlateTectonicsResources.RESOURCES.getResourceAsStream("images/textures/noise.png"));
            byte[] byArray = (byte[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            for (int i = 0; i < byArray.length; i += 4) {
                byArray[i] = (byte)(byArray[i] & 0x7F | 0x80);
                byArray[i + 1] = (byte)(byArray[i + 1] & 0x7F | 0x80);
                byArray[i + 2] = (byte)(byArray[i + 2] & 0x7F | 0x80);
                byArray[i + 3] = -1;
            }
            buffer.clear();
            buffer.put(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException("failure to read noise file", iOException);
        }
        buffer.rewind();
    }
}

