/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.platetectonics.view.materials;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.platetectonics.model.CrustModel;
import edu.colorado.phet.platetectonics.view.materials.EarthMaterial;
import java.awt.Color;

public class TemperatureMaterial
implements EarthMaterial {
    private static final Color min = new Color(64, 64, 64);
    private static final Color max = new Color(255, 64, 64);

    public static Vector2F temperatureMap(float f) {
        float f2 = CrustModel.ZERO_CELSIUS;
        float f3 = CrustModel.ZERO_CELSIUS + 6100.0f + 300.0f;
        float f4 = (f - f2) / (f3 - f2);
        f4 = (float)Math.pow(f4, 0.4f);
        f4 = (float)MathUtil.clamp(0.08, f4, 0.95);
        return new Vector2F(f4, 0.5f);
    }

    public Color getColor(float f, float f2, Vector2F vector2F, float f3) {
        float f4 = TemperatureMaterial.temperatureMap((float)f2).x;
        return new Color(0.25f + 0.75f * f4, 0.25f, 0.25f, f3);
    }

    public Color getMinColor() {
        return min;
    }

    public Color getMaxColor() {
        return max;
    }
}

