/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.slider;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Or;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function3;
import edu.colorado.phet.common.phetcommon.view.graphics.TriColorRoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.Spacer;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class KnobNode
extends PNode {
    private final Property<Boolean> enabled = new Property<Boolean>(true);
    private final BooleanProperty entered = new BooleanProperty(false);
    private final BooleanProperty pressed = new BooleanProperty(false);
    private final Or focused = this.entered.or(this.pressed);
    private final CursorHandler cursorHandler = new CursorHandler();
    private PComponent component;

    public KnobNode(final double d, ColorScheme colorScheme) {
        double d2 = d * 1.6;
        Function3<Color, Color, Color, TriColorRoundGradientPaint> function3 = new Function3<Color, Color, Color, TriColorRoundGradientPaint>(){

            @Override
            public TriColorRoundGradientPaint apply(Color color, Color color2, Color color3) {
                return new TriColorRoundGradientPaint(color, color2, color3, d / 2.0, d * 3.0 / 4.0, d / 2.5, d / 3.0);
            }
        };
        final TriColorRoundGradientPaint triColorRoundGradientPaint = (TriColorRoundGradientPaint)function3.apply(colorScheme.upInner, colorScheme.upMiddle, colorScheme.upOuter);
        final TriColorRoundGradientPaint triColorRoundGradientPaint2 = (TriColorRoundGradientPaint)function3.apply(colorScheme.overInner, colorScheme.overMiddle, colorScheme.overOuter);
        final TriColorRoundGradientPaint triColorRoundGradientPaint3 = (TriColorRoundGradientPaint)function3.apply(colorScheme.disabledInner, colorScheme.disabledMiddle, colorScheme.disabledOuter);
        this.addChild(new Spacer(0.0, 0.0, d + 1.0, d + 1.0));
        double d3 = 0.25;
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, d, d2, d * d3, d * d3));
        double d4 = 1.5707963267948966;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d / 2.0, d2);
        doubleGeneralPath.lineToRelative(new Vector2D(0.0, -d2).getRotatedInstance(d4 / 2.0));
        doubleGeneralPath.lineToRelative(0.0, d2);
        doubleGeneralPath.moveTo(d / 2.0, d2);
        doubleGeneralPath.lineToRelative(new Vector2D(0.0, -d2).getRotatedInstance(-d4 / 2.0));
        doubleGeneralPath.lineToRelative(0.0, d2);
        area.subtract(new Area(doubleGeneralPath.getGeneralPath()));
        PhetPPath phetPPath = new PhetPPath(area){
            {
                super(shape);
                this.setPaint(triColorRoundGradientPaint);
                this.setStroke(new BasicStroke(2.0f, 1, 2));
                new RichSimpleObserver(){

                    public void update() {
                        this.setPaint((Boolean)KnobNode.this.enabled.get() == false ? triColorRoundGradientPaint3 : ((Boolean)KnobNode.this.focused.get() != false ? triColorRoundGradientPaint2 : triColorRoundGradientPaint));
                        this.setStrokePaint((Boolean)KnobNode.this.enabled.get() == false ? Color.gray : ((Boolean)KnobNode.this.focused.get() != false ? new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(160, 160, 160), new Point2D.Double(d, d), Color.black) : new GradientPaint(new Point2D.Double(0.0, 0.0), Color.lightGray, new Point2D.Double(d, d), Color.black)));
                    }
                }.observe(KnobNode.this.enabled, KnobNode.this.focused);
            }
        };
        this.addChild(phetPPath);
        this.addInputEventListener(this.cursorHandler);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
                KnobNode.this.entered.set(true);
            }

            public void mousePressed(PInputEvent pInputEvent) {
                KnobNode.this.pressed.set(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                KnobNode.this.pressed.set(false);
            }

            public void mouseExited(PInputEvent pInputEvent) {
                KnobNode.this.entered.set(false);
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseMoved(PInputEvent pInputEvent) {
                KnobNode.this.component = pInputEvent.getComponent();
            }
        });
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.entered.set(false);
            this.pressed.set(false);
        }
        this.enabled.set(bl);
        this.setPickable(bl);
        this.setChildrenPickable(bl);
        if (this.component != null && !bl) {
            this.cursorHandler.mouseExited((JComponent)((Object)this.component));
        }
    }

    public static class ColorScheme {
        public final Color upInner;
        public final Color upMiddle;
        public final Color upOuter;
        public final Color overInner;
        public final Color overMiddle;
        public final Color overOuter;
        public final Color disabledInner;
        public final Color disabledMiddle;
        public final Color disabledOuter;

        public ColorScheme(Color color) {
            this(ColorScheme.add(color, -20, -20, -20), color, ColorScheme.add(color, 35, 35, 35), ColorScheme.add(color, -10, 30, 30), ColorScheme.add(color, 10, 30, 30), ColorScheme.add(color, 45, 45, 45), ColorScheme.add(color, 35, 35, 35), ColorScheme.add(color, 0, -20, -20), ColorScheme.add(color, -20, -20, -20), ColorUtils.darkerColor(Color.lightGray, 0.05), Color.lightGray, ColorUtils.brighterColor(Color.lightGray, 0.4));
        }

        private static Color add(Color color, int n, int n2, int n3) {
            return new Color(MathUtil.clamp(0, color.getRed() + n, 255), MathUtil.clamp(0, color.getGreen() + n2, 255), MathUtil.clamp(0, color.getBlue() + n3, 255));
        }

        public ColorScheme() {
            this(new Color(220, 220, 220));
        }

        public ColorScheme(Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, Color color8, Color color9, Color color10, Color color11, Color color12) {
            this.upInner = color;
            this.upMiddle = color2;
            this.upOuter = color3;
            this.overInner = color4;
            this.overMiddle = color5;
            this.overOuter = color6;
            this.disabledInner = color10;
            this.disabledMiddle = color11;
            this.disabledOuter = color12;
        }
    }
}

