/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics;

import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.menu.TeacherMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.ManualGeneExpressionModule;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.MessengerRnaProductionModule;
import edu.colorado.phet.geneexpressionbasics.multiplecells.MultipleCellsModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class GeneExpressionBasicsApplication
extends PiccoloPhetApplication {
    private static final String NAME = "gene-expression-basics";
    private final ManualGeneExpressionModule manualGeneExpressionModule = new ManualGeneExpressionModule(GeneExpressionBasicsResources.Strings.TAB__CELL_GENE_EXPRESSION);

    public GeneExpressionBasicsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.addModule(this.manualGeneExpressionModule);
        this.addModule(new MessengerRnaProductionModule(GeneExpressionBasicsResources.Strings.TAB__MESSENGER_RNA_PRODUCTION));
        this.addModule(new MultipleCellsModule(GeneExpressionBasicsResources.Strings.TAB__MULTIPLE_CELLS, this.getPhetFrame()));
        this.initMenuBar();
    }

    protected void initMenuBar() {
        final TeacherMenu teacherMenu = new TeacherMenu();
        final JMenuItem jMenuItem = new JMenuItem(GeneExpressionBasicsResources.Strings.ZOOM_IN){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GeneExpressionBasicsApplication.this.manualGeneExpressionModule.setCanvasZoomedIn(true);
                    }
                });
            }
        };
        final JMenuItem jMenuItem2 = new JMenuItem(GeneExpressionBasicsResources.Strings.ZOOM_OUT){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GeneExpressionBasicsApplication.this.manualGeneExpressionModule.setCanvasZoomedIn(false);
                    }
                });
            }
        };
        this.manualGeneExpressionModule.getCanvasZoomedInProperty().addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                if (d == 1.0) {
                    teacherMenu.remove(jMenuItem);
                    teacherMenu.add(jMenuItem2);
                } else {
                    teacherMenu.add(jMenuItem);
                    teacherMenu.remove(jMenuItem2);
                }
            }
        });
        this.addModuleObserver(new ModuleObserverAdapter(){

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                if (moduleEvent.getModule() == GeneExpressionBasicsApplication.this.manualGeneExpressionModule) {
                    GeneExpressionBasicsApplication.this.getPhetFrame().addMenu(teacherMenu);
                } else {
                    GeneExpressionBasicsApplication.this.getPhetFrame().removeMenu(teacherMenu);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(stringArray, NAME, GeneExpressionBasicsApplication.class);
    }

    private static class ModuleObserverAdapter
    implements ModuleObserver {
        private ModuleObserverAdapter() {
        }

        public void moduleAdded(ModuleEvent moduleEvent) {
        }

        public void activeModuleChanged(ModuleEvent moduleEvent) {
        }

        public void moduleRemoved(ModuleEvent moduleEvent) {
        }
    }
}

