/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;

public class AttachmentSite {
    public final Property<Vector2D> locationProperty = new Property<Vector2D>(new Vector2D(0.0, 0.0));
    public final BoundedDoubleProperty affinityProperty;
    public final Property<MobileBiomolecule> attachedOrAttachingMolecule = new Property<Object>(null);

    public AttachmentSite(Vector2D vector2D, double d) {
        this.locationProperty.set(vector2D);
        this.affinityProperty = new BoundedDoubleProperty(d, 0.0, 1.0);
    }

    public double getAffinity() {
        return (Double)this.affinityProperty.get();
    }

    public boolean isMoleculeAttached() {
        return this.attachedOrAttachingMolecule.get() != null && this.locationProperty.get().distance(this.attachedOrAttachingMolecule.get().getPosition()) < 10.0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AttachmentSite)) {
            return false;
        }
        AttachmentSite attachmentSite = (AttachmentSite)object;
        return ((Double)this.affinityProperty.get()).equals(attachmentSite.affinityProperty.get()) && this.locationProperty.get().equals(attachmentSite.locationProperty.get());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoundedDoubleProperty
    extends Property<Double> {
        private final Property<DoubleRange> bounds;

        public BoundedDoubleProperty(Double d, double d2, double d3) {
            super(d);
            this.bounds = new Property<DoubleRange>(new DoubleRange(d2, d3));
        }

        @Override
        public void set(Double d) {
            double d2 = MathUtil.clamp(this.bounds.get().getMin(), d, this.bounds.get().getMax());
            super.set(d2);
        }
    }
}

