/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioShapeUtils {
    private BioShapeUtils() {
    }

    public static Shape createdDistortedRoundedShapeFromPoints(List<Point2D> list, double d, long l) {
        Point2D point2D2;
        Shape shape = ShapeUtils.createRoundedShapeFromPoints(list);
        Point2D.Double double_ = new Point2D.Double(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY());
        Random random = new Random(l);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        for (Point2D point2D2 : list) {
            MutableVector2D mutableVector2D = new MutableVector2D(point2D2);
            mutableVector2D.scale(1.0 + (random.nextDouble() - 0.5) * d);
            arrayList.add(mutableVector2D.toPoint2D());
        }
        Object object = ShapeUtils.createRoundedShapeFromPoints(arrayList);
        point2D2 = new Point2D.Double(object.getBounds2D().getCenterX(), object.getBounds2D().getCenterY());
        object = AffineTransform.getTranslateInstance(((Point2D)double_).getX() - point2D2.getX(), ((Point2D)double_).getY() - point2D2.getY()).createTransformedShape((Shape)object);
        return object;
    }

    private static Shape createRandomShapeFromPoints(List<Point2D> list, int n) {
        Random random = new Random(n);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(list.get(0));
        for (int i = 0; i < list.size(); ++i) {
            Vector2D vector2D = new Vector2D(list.get(i));
            Vector2D vector2D2 = new Vector2D(list.get((i + 1) % list.size()));
            Vector2D vector2D3 = new Vector2D(list.get(i - 1 >= 0 ? i - 1 : list.size() - 1));
            Vector2D vector2D4 = new Vector2D(list.get((i + 2) % list.size()));
            Vector2D vector2D5 = ShapeUtils.extrapolateControlPoint(vector2D3, vector2D, vector2D2);
            Vector2D vector2D6 = ShapeUtils.extrapolateControlPoint(vector2D4, vector2D2, vector2D);
            if (random.nextBoolean()) {
                doubleGeneralPath.curveTo(vector2D5.getX(), vector2D5.getY(), vector2D6.getX(), vector2D6.getY(), vector2D2.getX(), vector2D2.getY());
                continue;
            }
            doubleGeneralPath.lineTo(vector2D2.getX(), vector2D2.getY());
        }
        return doubleGeneralPath.getGeneralPath();
    }

    public static Shape createRandomShape(Dimension2D dimension2D, int n) {
        Random random = new Random(n);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        for (double d = 0.0; d < 5.969026041820607; d += 0.3141592653589793 + random.nextDouble() * Math.PI / 10.0) {
            arrayList.add(Vector2D.createPolar(0.5 + random.nextDouble(), d).toPoint2D());
        }
        Shape shape = BioShapeUtils.createRandomShapeFromPoints(arrayList, n);
        double d = dimension2D.getWidth() / shape.getBounds2D().getWidth();
        double d2 = dimension2D.getHeight() / shape.getBounds2D().getHeight();
        return AffineTransform.getScaleInstance(d, d2).createTransformedShape(shape);
    }

    public static Shape createCurvyLineFromPoints(List<Point2D> list) {
        assert (list.size() > 0);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(list.get(0));
        if (list.size() == 1 || list.size() == 2) {
            doubleGeneralPath.lineTo(list.get(list.size() - 1));
            return doubleGeneralPath.getGeneralPath();
        }
        Vector2D vector2D = ShapeUtils.extrapolateControlPoint(new Vector2D(list.get(2)), new Vector2D(list.get(1)), new Vector2D(list.get(0)));
        doubleGeneralPath.quadTo(vector2D.getX(), vector2D.getY(), list.get(1).getX(), list.get(1).getY());
        for (int i = 1; i < list.size() - 2; ++i) {
            Vector2D vector2D2 = new Vector2D(list.get(i));
            Vector2D vector2D3 = new Vector2D(list.get(i + 1));
            Vector2D vector2D4 = new Vector2D(list.get(i - 1));
            Vector2D vector2D5 = new Vector2D(list.get(i + 2));
            Vector2D vector2D6 = ShapeUtils.extrapolateControlPoint(vector2D4, vector2D2, vector2D3);
            Vector2D vector2D7 = ShapeUtils.extrapolateControlPoint(vector2D5, vector2D3, vector2D2);
            doubleGeneralPath.curveTo(vector2D6.getX(), vector2D6.getY(), vector2D7.getX(), vector2D7.getY(), vector2D3.getX(), vector2D3.getY());
        }
        vector2D = ShapeUtils.extrapolateControlPoint(new Vector2D(list.get(list.size() - 3)), new Vector2D(list.get(list.size() - 2)), new Vector2D(list.get(list.size() - 1)));
        doubleGeneralPath.quadTo(vector2D.getX(), vector2D.getY(), list.get(list.size() - 1).getX(), list.get(list.size() - 1).getY());
        return doubleGeneralPath.getGeneralPath();
    }

    public static Shape createEColiLikeShape(Point2D point2D, double d, double d2, double d3, long l) {
        double d4;
        int n;
        assert (d > d2);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Random random = new Random(l);
        double d5 = d2 / 2.0;
        double d6 = d - d2;
        double d7 = d / 2.0 - d2 / 2.0;
        double d8 = -d / 2.0 + d2 / 2.0;
        double d9 = 0.0;
        for (n = 0; n < 8; ++n) {
            Point2D.Double double_ = new Point2D.Double(d8 + (double)n * (d6 / 7.0), d9 - d2 / 2.0);
            double_.setLocation(double_.getX(), double_.getY() + (random.nextDouble() - 0.5) * d2 * 0.025);
            arrayList.add(double_);
        }
        for (n = 1; n < 8; ++n) {
            double d10 = -1.5707963267948966 + (double)n * 0.4487989505128276;
            d4 = d5 + (random.nextDouble() - 0.5) * d2 * 0.025;
            arrayList.add(new Point2D.Double(d7 + d4 * Math.cos(d10), d4 * Math.sin(d10)));
        }
        for (n = 1; n < 8; ++n) {
            Point2D.Double double_ = new Point2D.Double(d7 - (double)n * (d6 / 7.0), d9 + d2 / 2.0);
            double_.setLocation(double_.getX(), double_.getY() + (random.nextDouble() - 0.5) * d2 * 0.025);
            arrayList.add(double_);
        }
        for (n = 1; n < 7; ++n) {
            double d11 = 1.5707963267948966 + (double)n * 0.4487989505128276;
            d4 = d5 + (random.nextDouble() - 0.5) * d2 * 0.025;
            arrayList.add(new Point2D.Double(d8 + d4 * Math.cos(d11), d4 * Math.sin(d11)));
        }
        Shape shape = ShapeUtils.createRoundedShapeFromPoints(arrayList);
        Shape shape2 = AffineTransform.getRotateInstance(d3).createTransformedShape(shape);
        Shape shape3 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(shape2);
        return shape3;
    }
}

