/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.BasePair;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaSeparation;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.ShapeChangingModelElement;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaMolecule {
    private final GeneExpressionModel model;
    private final double moleculeLength;
    private final double numberOfTwists;
    private final double leftEdgeXOffset;
    private final List<DnaStrandPoint> strandPoints = new ArrayList<DnaStrandPoint>();
    private final List<DnaStrandPoint> strandPointsShadow;
    private final List<DnaStrandSegment> strand1Segments = new ArrayList<DnaStrandSegment>();
    private final List<DnaStrandSegment> strand2Segments = new ArrayList<DnaStrandSegment>();
    private final ArrayList<BasePair> basePairs = new ArrayList();
    private final ArrayList<Gene> genes = new ArrayList();
    private final List<DnaSeparation> separations = new ArrayList<DnaSeparation>();
    private final boolean pursueAttachments;

    public DnaMolecule(int n, double d, boolean bl) {
        this(new StubGeneExpressionModel(), n, d, bl);
    }

    public DnaMolecule(GeneExpressionModel geneExpressionModel, int n, double d, boolean bl) {
        this.model = geneExpressionModel;
        this.leftEdgeXOffset = d;
        this.pursueAttachments = bl;
        this.moleculeLength = (double)n * 34.0;
        this.numberOfTwists = this.moleculeLength / 340.0;
        int n2 = 0;
        while ((double)n2 < this.moleculeLength / 34.0) {
            double d2 = d + (double)n2 * 34.0;
            this.strandPoints.add(new DnaStrandPoint(d2, this.getDnaStrandYPosition(d2, 0.0), this.getDnaStrandYPosition(d2, 102.0)));
            ++n2;
        }
        this.strandPointsShadow = new ArrayList<DnaStrandPoint>(this.strandPoints.size());
        for (DnaStrandPoint dnaStrandPoint : this.strandPoints) {
            this.strandPointsShadow.add(new DnaStrandPoint(dnaStrandPoint));
        }
        this.initializeStrandSegments();
        for (double d3 = d; d3 <= this.strandPoints.get((int)(this.strandPoints.size() - 1)).xPos; d3 += 34.0) {
            double d4 = this.getDnaStrandYPosition(d3, 0.0);
            double d5 = this.getDnaStrandYPosition(d3, 102.0);
            double d6 = Math.abs(d4 - d5);
            double d7 = (d4 + d5) / 2.0;
            this.basePairs.add(new BasePair(new Point2D.Double(d3, d7), d6));
        }
    }

    public void stepInTime(double d) {
        this.updateStrandSegments();
        for (Gene gene : this.genes) {
            gene.updateAffinities();
        }
    }

    public double getLength() {
        return this.moleculeLength;
    }

    public void addGene(Gene gene) {
        this.genes.add(gene);
    }

    public double getBasePairXOffsetByIndex(int n) {
        return this.leftEdgeXOffset + 102.0 + (double)n * 34.0;
    }

    public void addSeparation(DnaSeparation dnaSeparation) {
        this.separations.add(dnaSeparation);
    }

    public void removeSeparation(DnaSeparation dnaSeparation) {
        if (!this.separations.contains(dnaSeparation)) {
            System.out.println(this.getClass().getName() + " - Warning: Ignoring attempt to remove separation that can't be found.");
        } else {
            this.separations.remove(dnaSeparation);
        }
    }

    private int getBasePairIndexFromXOffset(double d) {
        assert (d >= this.leftEdgeXOffset && d < this.leftEdgeXOffset + this.moleculeLength);
        d = MathUtil.clamp(this.leftEdgeXOffset, d, this.leftEdgeXOffset + 340.0 * this.numberOfTwists);
        return (int)Math.round((d - this.leftEdgeXOffset - 102.0) / 34.0);
    }

    private double getNearestBasePairXOffset(double d) {
        return this.getBasePairXOffsetByIndex(this.getBasePairIndexFromXOffset(d));
    }

    private void initializeStrandSegments() {
        assert (this.strandPoints.size() > 0);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
        double d = this.strandPoints.get((int)0).xPos;
        boolean bl = true;
        for (DnaStrandPoint dnaStrandPoint : this.strandPoints) {
            double d2 = dnaStrandPoint.xPos;
            arrayList.add(new Point2D.Double(d2, dnaStrandPoint.strand1YPos));
            arrayList2.add(new Point2D.Double(d2, dnaStrandPoint.strand2YPos));
            if (!(d2 - d >= 170.0)) continue;
            this.strand1Segments.add(new DnaStrandSegment(BioShapeUtils.createCurvyLineFromPoints(arrayList), bl));
            this.strand2Segments.add(new DnaStrandSegment(BioShapeUtils.createCurvyLineFromPoints(arrayList2), !bl));
            Point2D point2D = (Point2D)arrayList.get(arrayList.size() - 1);
            arrayList.clear();
            arrayList.add(point2D);
            point2D = (Point2D)arrayList2.get(arrayList2.size() - 1);
            arrayList2.clear();
            arrayList2.add(point2D);
            d = point2D.getX();
            bl = !bl;
        }
    }

    private double getDnaStrandYPosition(double d, double d2) {
        return Math.sin((d + d2) / 340.0 * Math.PI * 2.0) * 200.0 / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    private void updateStrandSegments() {
        void var2_7;
        Object object;
        for (DnaStrandPoint object2 : this.strandPointsShadow) {
            object2.strand1YPos = this.getDnaStrandYPosition(object2.xPos, 0.0);
            object2.strand2YPos = this.getDnaStrandYPosition(object2.xPos, 102.0);
        }
        for (DnaSeparation dnaSeparation : this.separations) {
            double d = dnaSeparation.getAmount() * 1.5;
            object = new IntegerRange((int)Math.floor((dnaSeparation.getXPos() - d / 2.0 - this.leftEdgeXOffset) / 34.0), (int)Math.floor((dnaSeparation.getXPos() + d / 2.0 - this.leftEdgeXOffset) / 34.0));
            for (int i = ((IntegerRange)object).getMin(); i < ((IntegerRange)object).getMax(); ++i) {
                double d2 = (((IntegerRange)object).getMin() + ((IntegerRange)object).getMax()) / 2;
                if (i < 0 || i >= this.strandPointsShadow.size()) continue;
                double d3 = 1.0 - Math.abs(2.0 * ((double)i - d2) / (double)((IntegerRange)object).getLength());
                this.strandPointsShadow.get((int)i).strand1YPos = (1.0 - d3) * this.strandPointsShadow.get((int)i).strand1YPos + d3 * dnaSeparation.getAmount() / 2.0;
                this.strandPointsShadow.get((int)i).strand2YPos = (1.0 - d3) * this.strandPointsShadow.get((int)i).strand2YPos - d3 * dnaSeparation.getAmount() / 2.0;
            }
        }
        int n = this.strand1Segments.size();
        assert (n == this.strand2Segments.size());
        boolean bl = false;
        while (var2_7 < n) {
            boolean bl2 = false;
            DnaStrandSegment dnaStrandSegment = this.strand1Segments.get((int)var2_7);
            object = this.strand2Segments.get((int)var2_7);
            Rectangle2D rectangle2D = dnaStrandSegment.getShape().getBounds2D();
            IntegerRange integerRange = new IntegerRange((int)Math.floor((rectangle2D.getMinX() - this.leftEdgeXOffset) / 34.0), (int)Math.floor((rectangle2D.getMaxX() - this.leftEdgeXOffset) / 34.0));
            for (int i = integerRange.getMin(); i <= integerRange.getMax(); ++i) {
                if (this.strandPoints.get(i).equals(this.strandPointsShadow.get(i))) continue;
                this.strandPoints.get(i).set(this.strandPointsShadow.get(i));
                bl2 = true;
            }
            if (bl2) {
                ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
                ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
                for (int i = integerRange.getMin(); i <= integerRange.getMax(); ++i) {
                    arrayList.add(new Point2D.Double(this.strandPoints.get((int)i).xPos, this.strandPoints.get((int)i).strand1YPos));
                    arrayList2.add(new Point2D.Double(this.strandPoints.get((int)i).xPos, this.strandPoints.get((int)i).strand2YPos));
                }
                dnaStrandSegment.setShape(BioShapeUtils.createCurvyLineFromPoints(arrayList));
                ((DnaStrandSegment)object).setShape(BioShapeUtils.createCurvyLineFromPoints(arrayList2));
            }
            ++var2_7;
        }
    }

    public List<DnaStrandSegment> getStrand1Segments() {
        return this.strand1Segments;
    }

    public List<DnaStrandSegment> getStrand2Segments() {
        return this.strand2Segments;
    }

    public ArrayList<Gene> getGenes() {
        return this.genes;
    }

    public Gene getLastGene() {
        return this.genes.get(this.genes.size() - 1);
    }

    public ArrayList<BasePair> getBasePairs() {
        return this.basePairs;
    }

    public void activateHints(MobileBiomolecule mobileBiomolecule) {
        for (Gene gene : this.genes) {
            gene.activateHints(mobileBiomolecule);
        }
    }

    public void deactivateAllHints() {
        for (Gene gene : this.genes) {
            gene.deactivateHints();
        }
    }

    public Point2D getLeftEdgePos() {
        return new Point2D.Double(this.leftEdgeXOffset, 0.0);
    }

    public AttachmentSite considerProposalFrom(final TranscriptionFactor transcriptionFactor) {
        return this.considerProposalFromBiomolecule(transcriptionFactor, 400.0, new Function1<Integer, AttachmentSite>(){

            @Override
            public AttachmentSite apply(Integer n) {
                return DnaMolecule.this.getTranscriptionFactorAttachmentSiteForBasePairIndex(n, transcriptionFactor.getConfig());
            }
        }, new Function1<Gene, Boolean>(){

            @Override
            public Boolean apply(Gene gene) {
                return true;
            }
        }, new Function1<Gene, AttachmentSite>(){

            @Override
            public AttachmentSite apply(Gene gene) {
                return gene.getMatchingSite(transcriptionFactor.getConfig());
            }
        });
    }

    public AttachmentSite considerProposalFrom(RnaPolymerase rnaPolymerase) {
        return this.considerProposalFromBiomolecule(rnaPolymerase, 400.0, new Function1<Integer, AttachmentSite>(){

            @Override
            public AttachmentSite apply(Integer n) {
                return DnaMolecule.this.getRnaPolymeraseAttachmentSiteForBasePairIndex(n);
            }
        }, new Function1<Gene, Boolean>(){

            @Override
            public Boolean apply(Gene gene) {
                return gene.transcriptionFactorsSupportTranscription();
            }
        }, new Function1<Gene, AttachmentSite>(){

            @Override
            public AttachmentSite apply(Gene gene) {
                return gene.getPolymeraseAttachmentSite();
            }
        });
    }

    private AttachmentSite considerProposalFromBiomolecule(MobileBiomolecule mobileBiomolecule, double d, Function1<Integer, AttachmentSite> function1, Function1<Gene, Boolean> function12, Function1<Gene, AttachmentSite> function13) {
        AttachmentSite attachmentSite;
        List<AttachmentSite> list = new ArrayList<AttachmentSite>();
        for (int i = 0; i < this.basePairs.size(); ++i) {
            Vector2D object = new Vector2D(this.basePairs.get(i).getCenterLocation().getX(), 0.0);
            if (!(object.distance(mobileBiomolecule.getPosition()) <= d)) continue;
            attachmentSite = function1.apply(i);
            if (attachmentSite.attachedOrAttachingMolecule.get() != null) continue;
            list.add(attachmentSite);
        }
        if (list.size() == 0 && this.pursueAttachments) {
            for (Gene gene : this.genes) {
                double d2;
                double d3;
                if (!function12.apply(gene).booleanValue()) continue;
                attachmentSite = function13.apply(gene);
                if (attachmentSite.attachedOrAttachingMolecule.get() == null) {
                    list.add(attachmentSite);
                    continue;
                }
                if (attachmentSite.isMoleculeAttached() || !((d3 = mobileBiomolecule.getPosition().distance(attachmentSite.locationProperty.get())) < (d2 = attachmentSite.attachedOrAttachingMolecule.get().getPosition().distance(attachmentSite.locationProperty.get())))) continue;
                attachmentSite.attachedOrAttachingMolecule.get().forceAbortPendingAttachment();
                list.add(attachmentSite);
            }
        }
        if ((list = this.eliminateInvalidAttachmentSites(mobileBiomolecule, list)).size() == 0) {
            return null;
        }
        Collections.sort(list, new AttachmentSiteComparator(mobileBiomolecule.getPosition()));
        return list.get(0);
    }

    private List<AttachmentSite> eliminateInvalidAttachmentSites(final MobileBiomolecule mobileBiomolecule, List<AttachmentSite> list) {
        return FunctionalUtils.filter(list, new Function1<AttachmentSite, Boolean>(){

            @Override
            public Boolean apply(AttachmentSite attachmentSite) {
                Vector2D vector2D = new Vector2D(mobileBiomolecule.getPosition(), attachmentSite.locationProperty.get());
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(vector2D.getX(), vector2D.getY());
                Shape shape = affineTransform.createTransformedShape(mobileBiomolecule.getShape());
                boolean bl = mobileBiomolecule.motionBoundsProperty.get().inBounds(shape);
                boolean bl2 = false;
                for (MobileBiomolecule mobileBiomolecule2 : DnaMolecule.this.model.getOverlappingBiomolecules(shape)) {
                    if (!((Boolean)mobileBiomolecule2.attachedToDna.get()).booleanValue() || mobileBiomolecule2 == mobileBiomolecule) continue;
                    bl2 = true;
                    break;
                }
                return bl && !bl2;
            }
        });
    }

    private AttachmentSite getTranscriptionFactorAttachmentSiteForBasePairIndex(int n, TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        Gene gene = this.getGeneContainingBasePair(n);
        if (gene != null) {
            return gene.getTranscriptionFactorAttachmentSite(n, transcriptionFactorConfig);
        }
        return this.createDefaultAffinityAttachmentSite(n);
    }

    private AttachmentSite getRnaPolymeraseAttachmentSiteForBasePairIndex(int n) {
        Gene gene = this.getGeneContainingBasePair(n);
        if (gene != null) {
            return gene.getPolymeraseAttachmentSite(n);
        }
        return this.createDefaultAffinityAttachmentSite(n);
    }

    public List<AttachmentSite> getAdjacentAttachmentSites(TranscriptionFactor transcriptionFactor, AttachmentSite attachmentSite) {
        AttachmentSite attachmentSite2;
        int n = this.getBasePairIndexFromXOffset(attachmentSite.locationProperty.get().getX());
        ArrayList<AttachmentSite> arrayList = new ArrayList<AttachmentSite>();
        if (n != 0) {
            attachmentSite2 = this.getTranscriptionFactorAttachmentSiteForBasePairIndex(n - 1, transcriptionFactor.getConfig());
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null) {
                arrayList.add(attachmentSite2);
            }
        }
        if (n != this.basePairs.size() - 1) {
            attachmentSite2 = this.getTranscriptionFactorAttachmentSiteForBasePairIndex(n + 1, transcriptionFactor.getConfig());
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null) {
                arrayList.add(attachmentSite2);
            }
        }
        return this.eliminateInvalidAttachmentSites(transcriptionFactor, arrayList);
    }

    public List<AttachmentSite> getAdjacentAttachmentSites(RnaPolymerase rnaPolymerase, AttachmentSite attachmentSite) {
        AttachmentSite attachmentSite2;
        int n = this.getBasePairIndexFromXOffset(attachmentSite.locationProperty.get().getX());
        ArrayList<AttachmentSite> arrayList = new ArrayList<AttachmentSite>();
        if (n != 0) {
            attachmentSite2 = this.getRnaPolymeraseAttachmentSiteForBasePairIndex(n - 1);
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null) {
                arrayList.add(attachmentSite2);
            }
        }
        if (n != this.basePairs.size() - 1) {
            attachmentSite2 = this.getRnaPolymeraseAttachmentSiteForBasePairIndex(n + 1);
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null) {
                arrayList.add(attachmentSite2);
            }
        }
        return this.eliminateInvalidAttachmentSites(rnaPolymerase, arrayList);
    }

    private Gene getGeneContainingBasePair(int n) {
        Gene gene = null;
        for (Gene gene2 : this.genes) {
            if (!gene2.containsBasePair(n)) continue;
            gene = gene2;
            break;
        }
        return gene;
    }

    public AttachmentSite createDefaultAffinityAttachmentSite(double d) {
        return new AttachmentSite(new Vector2D(this.getNearestBasePairXOffset(d), 0.0), 0.05);
    }

    public AttachmentSite createDefaultAffinityAttachmentSite(int n) {
        return new AttachmentSite(new Vector2D(this.getBasePairXOffsetByIndex(n), 0.0), 0.05);
    }

    public Gene getGeneAtLocation(Vector2D vector2D) {
        if (!(vector2D.getX() >= this.leftEdgeXOffset && vector2D.getX() <= this.leftEdgeXOffset + this.moleculeLength && vector2D.getY() >= -100.0 && vector2D.getY() <= 100.0)) {
            System.out.println(this.getClass().getName() + " - Warning: Location for gene test is not on DNA molecule.");
            return null;
        }
        Gene gene = null;
        int n = this.getBasePairIndexFromXOffset(vector2D.getX());
        for (Gene gene2 : this.genes) {
            if (!gene2.containsBasePair(n)) continue;
            gene = gene2;
            break;
        }
        return gene;
    }

    public void reset() {
        for (Gene gene : this.genes) {
            gene.clearAttachmentSites();
        }
        this.separations.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttachmentSiteComparator<T extends AttachmentSite>
    implements Comparator<T> {
        private final Vector2D attachLocation;

        private AttachmentSiteComparator(Vector2D vector2D) {
            this.attachLocation = vector2D;
        }

        @Override
        public int compare(T t, T t2) {
            double d = 1.0;
            double d2 = ((AttachmentSite)t).getAffinity() / Math.pow(this.attachLocation.distance(((AttachmentSite)t).locationProperty.get()), d);
            double d3 = ((AttachmentSite)t2).getAffinity() / Math.pow(this.attachLocation.distance(((AttachmentSite)t2).locationProperty.get()), d);
            return Double.compare(d3, d2);
        }
    }

    protected class DnaStrandPoint {
        public double xPos = 0.0;
        public double strand1YPos = 0.0;
        public double strand2YPos = 0.0;

        public DnaStrandPoint(double d, double d2, double d3) {
            this.xPos = d;
            this.strand1YPos = d2;
            this.strand2YPos = d3;
        }

        public DnaStrandPoint(DnaStrandPoint dnaStrandPoint) {
            this.xPos = dnaStrandPoint.xPos;
            this.strand1YPos = dnaStrandPoint.strand1YPos;
            this.strand2YPos = dnaStrandPoint.strand2YPos;
        }

        public void set(DnaStrandPoint dnaStrandPoint) {
            this.xPos = dnaStrandPoint.xPos;
            this.strand1YPos = dnaStrandPoint.strand1YPos;
            this.strand2YPos = dnaStrandPoint.strand2YPos;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DnaStrandPoint dnaStrandPoint = (DnaStrandPoint)object;
            if (Double.compare(dnaStrandPoint.strand1YPos, this.strand1YPos) != 0) {
                return false;
            }
            if (Double.compare(dnaStrandPoint.strand2YPos, this.strand2YPos) != 0) {
                return false;
            }
            return Double.compare(dnaStrandPoint.xPos, this.xPos) == 0;
        }
    }

    public static class DnaStrandSegment
    extends ShapeChangingModelElement {
        public final boolean inFront;

        public DnaStrandSegment(Shape shape, boolean bl) {
            super(shape);
            this.inFront = bl;
        }

        public void setShape(Shape shape) {
            this.shapeProperty.set(shape);
        }
    }
}

