/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRnaDestroyer;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.PlacementHint;
import edu.colorado.phet.geneexpressionbasics.common.model.PointMass;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.common.model.Ribosome;
import edu.colorado.phet.geneexpressionbasics.common.model.ShapeSegment;
import edu.colorado.phet.geneexpressionbasics.common.model.WindingBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.MessengerRnaAttachmentStateMachine;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessengerRna
extends WindingBiomolecule {
    public final PlacementHint ribosomePlacementHint;
    public final PlacementHint mRnaDestroyerPlacementHint;
    public final BooleanProperty beingSynthesized = new BooleanProperty(true);
    private final Map<Ribosome, ShapeSegment> mapRibosomeToShapeSegment = new HashMap<Ribosome, ShapeSegment>();
    private MessengerRnaDestroyer messengerRnaDestroyer = null;
    private ShapeSegment segmentWhereDestroyerConnects = null;
    private final Protein proteinPrototype;
    private final MessengerRnaAttachmentStateMachine mRnaAttachmentStateMachine;

    public MessengerRna(GeneExpressionModel geneExpressionModel, Protein protein, Vector2D vector2D) {
        super(geneExpressionModel, (Shape)new DoubleGeneralPath(vector2D.toPoint2D()).getGeneralPath(), vector2D);
        this.proteinPrototype = protein;
        this.mRnaAttachmentStateMachine = (MessengerRnaAttachmentStateMachine)this.attachmentStateMachine;
        this.shapeSegments.add(new ShapeSegment.FlatSegment(vector2D){
            {
                this.setCapacity(100.0);
            }
        });
        this.ribosomePlacementHint = new PlacementHint(new Ribosome(geneExpressionModel));
        this.mRnaDestroyerPlacementHint = new PlacementHint(new MessengerRnaDestroyer(geneExpressionModel));
        this.shapeProperty.addObserver(new SimpleObserver(){

            public void update() {
                Vector2D vector2D = new Vector2D(MessengerRna.this.firstShapeDefiningPoint.getPosition());
                MessengerRna.this.ribosomePlacementHint.setPosition(vector2D.minus(Ribosome.OFFSET_TO_TRANSLATION_CHANNEL_ENTRANCE));
                MessengerRna.this.mRnaDestroyerPlacementHint.setPosition(vector2D);
            }
        });
    }

    public void translate(Vector2D vector2D) {
        super.translate(vector2D);
        Object object = this.shapeSegments.iterator();
        while (object.hasNext()) {
            ShapeSegment shapeSegment = (ShapeSegment)object.next();
            shapeSegment.translate(vector2D);
        }
        for (object = this.firstShapeDefiningPoint; object != null; object = ((PointMass)object).getNextPointMass()) {
            ((PointMass)object).translate(vector2D);
        }
    }

    public void setFadeAwayWhenFormed(boolean bl) {
        this.mRnaAttachmentStateMachine.setFadeAwayWhenFormed(bl);
    }

    public boolean advanceTranslation(Ribosome ribosome, double d) {
        ShapeSegment shapeSegment = this.mapRibosomeToShapeSegment.get(ribosome);
        assert (shapeSegment != null);
        shapeSegment.advance(d, this.shapeSegments);
        if (this.shapeSegments.contains(shapeSegment)) {
            this.realignSegmentsFrom(shapeSegment);
        }
        this.windPointsThroughSegments();
        return shapeSegment.getContainedLength() <= 0.0;
    }

    public boolean advanceDestruction(double d) {
        if (this.segmentWhereDestroyerConnects == null) {
            System.out.println(this.getClass().getName() + " - Warning: Attempt to advance the destruction of mRNA that has no content left.");
            return true;
        }
        this.reduceLength(d);
        if (this.shapeSegments.contains(this.segmentWhereDestroyerConnects)) {
            this.realignSegmentsFrom(this.segmentWhereDestroyerConnects);
        }
        if (this.shapeSegments.size() > 0) {
            this.windPointsThroughSegments();
        }
        return this.firstShapeDefiningPoint == this.lastShapeDefiningPoint;
    }

    private void reduceLength(double d) {
        if (d >= this.getLength()) {
            this.lastShapeDefiningPoint = this.firstShapeDefiningPoint;
            this.lastShapeDefiningPoint.setNextPointMass(null);
            this.shapeSegments.clear();
        } else {
            this.segmentWhereDestroyerConnects.advanceAndRemove(d, this.shapeSegments);
            double d2 = 0.0;
            while (d2 < d) {
                if (this.lastShapeDefiningPoint.getTargetDistanceToPreviousPoint() <= d - d2) {
                    d2 += this.lastShapeDefiningPoint.getTargetDistanceToPreviousPoint();
                    this.lastShapeDefiningPoint = this.lastShapeDefiningPoint.getPreviousPointMass();
                    this.lastShapeDefiningPoint.setNextPointMass(null);
                    continue;
                }
                this.lastShapeDefiningPoint.setTargetDistanceToPreviousPoint(this.lastShapeDefiningPoint.getTargetDistanceToPreviousPoint() - (d - d2));
                d2 = d;
            }
        }
    }

    public Protein getProteinPrototype() {
        return this.proteinPrototype;
    }

    public Vector2D getRibosomeAttachmentLocation(Ribosome ribosome) {
        if (!this.mapRibosomeToShapeSegment.containsKey(ribosome)) {
            System.out.println(this.getClass().getName() + " Warning: Ignoring attempt to obtain attachment point for non-attached ribosome.");
            return null;
        }
        ShapeSegment shapeSegment = this.mapRibosomeToShapeSegment.get(ribosome);
        Vector2D vector2D = this.shapeSegments.getPreviousItem(shapeSegment) == null ? new Vector2D(shapeSegment.getLowerRightCornerPos().getX() - 100.0, shapeSegment.getLowerRightCornerPos().getY()) : new Vector2D(shapeSegment.getUpperLeftCornerPos().getX() + ribosome.getTranslationChannelLength(), shapeSegment.getUpperLeftCornerPos().getY());
        return vector2D;
    }

    public void releaseFromRibosome(Ribosome ribosome) {
        assert (this.mapRibosomeToShapeSegment.containsKey(ribosome));
        this.mapRibosomeToShapeSegment.remove(ribosome);
        if (this.mapRibosomeToShapeSegment.isEmpty()) {
            this.mRnaAttachmentStateMachine.allRibosomesDetached();
        }
    }

    public void releaseFromPolymerase() {
        this.mRnaAttachmentStateMachine.detach();
    }

    public void activateHints(MobileBiomolecule mobileBiomolecule) {
        this.ribosomePlacementHint.activateIfMatch(mobileBiomolecule);
        this.mRnaDestroyerPlacementHint.activateIfMatch(mobileBiomolecule);
    }

    public void deactivateAllHints() {
        this.ribosomePlacementHint.active.set(false);
        this.mRnaDestroyerPlacementHint.active.set(false);
    }

    public void initiateTranslation(Ribosome ribosome) {
        assert (this.mapRibosomeToShapeSegment.containsKey(ribosome));
        ShapeSegment shapeSegment = (ShapeSegment)this.shapeSegments.get(0);
        assert (shapeSegment.isFlat());
        shapeSegment.setCapacity(ribosome.getTranslationChannelLength() + 100.0);
    }

    public void initiateDestruction(MessengerRnaDestroyer messengerRnaDestroyer) {
        assert (this.messengerRnaDestroyer == messengerRnaDestroyer);
        this.segmentWhereDestroyerConnects = (ShapeSegment)this.shapeSegments.get(0);
        assert (this.segmentWhereDestroyerConnects.isFlat());
        this.segmentWhereDestroyerConnects.setCapacity(messengerRnaDestroyer.getDestructionChannelLength() + 100.0);
    }

    public double getProportionOfRnaTranslated(Ribosome ribosome) {
        ShapeSegment shapeSegment;
        assert (this.mapRibosomeToShapeSegment.containsKey(ribosome));
        double d = 0.0;
        ShapeSegment shapeSegment2 = this.mapRibosomeToShapeSegment.get(ribosome);
        assert (shapeSegment2.isFlat());
        Iterator iterator = this.shapeSegments.iterator();
        while (iterator.hasNext() && (shapeSegment = (ShapeSegment)iterator.next()) != shapeSegment2) {
            d += shapeSegment.getContainedLength();
        }
        return Math.max((d += shapeSegment2.getContainedLength() - (shapeSegment2.getLowerRightCornerPos().getX() - shapeSegment2.attachmentSite.locationProperty.get().getX())) / this.getLength(), 0.0);
    }

    public AttachmentSite considerProposalFrom(Ribosome ribosome) {
        assert (!this.mapRibosomeToShapeSegment.containsKey(ribosome));
        AttachmentSite attachmentSite = null;
        if (this.messengerRnaDestroyer == null) {
            AttachmentSite attachmentSite2 = ((ShapeSegment)this.shapeSegments.get((int)0)).attachmentSite;
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null && attachmentSite2.locationProperty.get().distance(ribosome.getEntranceOfRnaChannelPos().toPoint2D()) < 400.0) {
                attachmentSite = attachmentSite2;
                this.mRnaAttachmentStateMachine.attachedToRibosome();
                this.mapRibosomeToShapeSegment.put(ribosome, (ShapeSegment)this.shapeSegments.get(0));
            }
        }
        return attachmentSite;
    }

    public AttachmentSite considerProposalFrom(MessengerRnaDestroyer messengerRnaDestroyer) {
        assert (this.messengerRnaDestroyer != messengerRnaDestroyer);
        AttachmentSite attachmentSite = null;
        if (this.messengerRnaDestroyer == null) {
            AttachmentSite attachmentSite2 = ((ShapeSegment)this.shapeSegments.get((int)0)).attachmentSite;
            if (attachmentSite2.attachedOrAttachingMolecule.get() == null && attachmentSite2.locationProperty.get().distance(messengerRnaDestroyer.getPosition()) < 400.0) {
                attachmentSite = attachmentSite2;
                this.mRnaAttachmentStateMachine.attachToDestroyer();
                this.messengerRnaDestroyer = messengerRnaDestroyer;
            }
        }
        return attachmentSite;
    }

    public void abortDestruction() {
        this.messengerRnaDestroyer = null;
        this.attachmentStateMachine.forceImmediateUnattachedAndAvailable();
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new MessengerRnaAttachmentStateMachine(this);
    }

    public Point2D getDestroyerAttachmentLocation() {
        assert (this.segmentWhereDestroyerConnects != null);
        if (this.segmentWhereDestroyerConnects == null) {
            return new Point2D.Double(0.0, 0.0);
        }
        return new Point2D.Double(this.segmentWhereDestroyerConnects.getLowerRightCornerPos().getX() - 100.0, this.segmentWhereDestroyerConnects.getLowerRightCornerPos().getY());
    }
}

