/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.RnaDestroyerAttachmentStateMachine;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.List;

public class MessengerRnaDestroyer
extends MobileBiomolecule {
    private MessengerRna messengerRnaBeingDestroyed;

    public MessengerRnaDestroyer(GeneExpressionModel geneExpressionModel) {
        this(geneExpressionModel, new Vector2D(0.0, 0.0));
    }

    public MessengerRnaDestroyer(GeneExpressionModel geneExpressionModel, Vector2D vector2D) {
        super(geneExpressionModel, MessengerRnaDestroyer.createShape(), new Color(255, 150, 66));
        this.setPosition(vector2D);
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new RnaDestroyerAttachmentStateMachine(this);
    }

    public boolean advanceMessengerRnaDestruction(double d) {
        return this.messengerRnaBeingDestroyed.advanceDestruction(d);
    }

    public AttachmentSite proposeAttachments() {
        AttachmentSite attachmentSite = null;
        List<MessengerRna> list = this.model.getMessengerRnaList();
        for (MessengerRna messengerRna : list) {
            attachmentSite = messengerRna.considerProposalFrom(this);
            if (attachmentSite == null) continue;
            this.messengerRnaBeingDestroyed = messengerRna;
            break;
        }
        return attachmentSite;
    }

    private static Shape createShape() {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-125.0, -125.0, 250.0, 250.0);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0){
            {
                this.lineTo(250.0, 200.0);
                this.lineTo(250.0, -200.0);
                this.closePath();
            }
        };
        Area area = new Area(double_);
        area.subtract(new Area(doubleGeneralPath.getGeneralPath()));
        return area;
    }

    public double getDestructionChannelLength() {
        return this.getShape().getBounds2D().getWidth() / 2.0;
    }

    public void initiateMessengerRnaDestruction() {
        this.messengerRnaBeingDestroyed.initiateDestruction(this);
    }

    public MessengerRna getMessengerRnaBeingDestroyed() {
        return this.messengerRnaBeingDestroyed;
    }

    public void clearMessengerRnaBeingDestroyed() {
        this.messengerRnaBeingDestroyed = null;
    }
}

