/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.ShapeChangingModelElement;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import java.awt.Color;
import java.awt.Shape;

public abstract class MobileBiomolecule
extends ShapeChangingModelElement {
    protected final GeneExpressionModel model;
    public final BooleanProperty userControlled = new BooleanProperty(false);
    public final Property<Color> colorProperty = new Property<Color>(Color.BLACK);
    public final Property<MotionBounds> motionBoundsProperty = new Property<MotionBounds>(new MotionBounds());
    private MotionStrategy motionStrategy = null;
    protected final AttachmentStateMachine attachmentStateMachine;
    public final Property<Double> zPosition = new Property<Double>(0.0);
    private boolean zMotionEnabled;
    public final Property<Double> existenceStrength = new Property<Double>(1.0);
    public final BooleanProperty movableByUser = new BooleanProperty(true);
    public final BooleanProperty attachedToDna = new BooleanProperty(false);

    protected MobileBiomolecule(GeneExpressionModel geneExpressionModel, Shape shape, Color color) {
        super(shape);
        this.model = geneExpressionModel;
        this.attachmentStateMachine = this.createAttachmentStateMachine();
        this.colorProperty.set(color);
        this.userControlled.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (bl2.booleanValue() && !bl.booleanValue()) {
                    MobileBiomolecule.this.handleReleasedByUser();
                }
            }
        });
    }

    protected abstract AttachmentStateMachine createAttachmentStateMachine();

    protected void handleReleasedByUser() {
        this.attachmentStateMachine.forceImmediateUnattachedAndAvailable();
    }

    public void stepInTime(double d) {
        if (!((Boolean)this.userControlled.get()).booleanValue()) {
            if (this.zMotionEnabled) {
                this.setPosition3D(this.motionStrategy.getNextLocation3D(this.getPosition3D(), this.getShape(), d));
            } else {
                this.setPosition(this.motionStrategy.getNextLocation(this.getPosition(), this.getShape(), d));
            }
            this.attachmentStateMachine.stepInTime(d);
        }
    }

    private Point3D getPosition3D() {
        return new Point3D.Double(this.getPosition().getX(), this.getPosition().getY(), this.zPosition.get());
    }

    public void setPosition3D(Point3D point3D) {
        this.setPosition(point3D.getX(), point3D.getY());
        this.zPosition.set(point3D.getZ());
    }

    public void set3DMotionEnabled(boolean bl) {
        this.zMotionEnabled = bl;
    }

    public Vector2D getDetachDirection() {
        return new Vector2D(0.0, 1.0);
    }

    public GeneExpressionModel getModel() {
        return this.model;
    }

    public void setMotionBounds(MotionBounds motionBounds) {
        this.motionBoundsProperty.set(motionBounds);
    }

    public void spawnMessengerRna(MessengerRna messengerRna) {
        this.model.addMessengerRna(messengerRna);
    }

    public void forceDetach() {
        if (this.attachmentStateMachine.isAttached()) {
            this.attachmentStateMachine.detach();
        } else if (this.attachmentStateMachine.isMovingTowardAttachment()) {
            this.attachmentStateMachine.forceImmediateUnattachedAndAvailable();
        }
    }

    public void forceAbortPendingAttachment() {
        if (this.attachmentStateMachine.isMovingTowardAttachment()) {
            this.attachmentStateMachine.forceImmediateUnattachedAndAvailable();
        } else {
            System.out.println(this.getClass().getName() + " - Warning: Commanded to abort attachment when attachment not pending.");
        }
    }

    public void changeConformation(double d) {
        throw new RuntimeException("Method 'changeConformation' not implemented in base class.");
    }

    public AttachmentSite proposeAttachments() {
        return null;
    }

    public void setMotionStrategy(MotionStrategy motionStrategy) {
        this.motionStrategy = motionStrategy;
    }
}

