/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.awt.geom.Point2D;

public class PointMass {
    private final Point2D position = new Point2D.Double(0.0, 0.0);
    private final MutableVector2D velocity = new MutableVector2D(0.0, 0.0);
    private final MutableVector2D acceleration = new MutableVector2D(0.0, 0.0);
    private PointMass previousPointMass = null;
    private PointMass nextPointMass = null;
    private double targetDistanceToPreviousPoint;

    public PointMass(Vector2D vector2D, double d) {
        this.setPosition(vector2D);
        this.targetDistanceToPreviousPoint = d;
    }

    public String toString() {
        return this.getClass().getName() + " Position: " + this.position.toString();
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
    }

    public void setPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX(), vector2D.getY());
    }

    public Vector2D getPosition() {
        return new Vector2D(this.position.getX(), this.position.getY());
    }

    public Vector2D getVelocity() {
        return new Vector2D(this.velocity.getX(), this.velocity.getY());
    }

    public void setAcceleration(Vector2D vector2D) {
        this.acceleration.setValue(vector2D);
    }

    public PointMass getPreviousPointMass() {
        return this.previousPointMass;
    }

    public void setPreviousPointMass(PointMass pointMass) {
        this.previousPointMass = pointMass;
    }

    public PointMass getNextPointMass() {
        return this.nextPointMass;
    }

    public void setNextPointMass(PointMass pointMass) {
        this.nextPointMass = pointMass;
    }

    public double getTargetDistanceToPreviousPoint() {
        return this.targetDistanceToPreviousPoint;
    }

    public double distance(PointMass pointMass) {
        return this.getPosition().distance(pointMass.getPosition());
    }

    public void update(double d) {
        this.velocity.setValue(this.velocity.plus(this.acceleration.times(d)));
        this.position.setLocation(this.position.getX() + this.velocity.getX() * d, this.position.getY() + this.velocity.getY() * d);
    }

    public void translate(Vector2D vector2D) {
        this.setPosition(this.position.getX() + vector2D.getX(), this.position.getY() + vector2D.getY());
    }

    public void setTargetDistanceToPreviousPoint(double d) {
        this.targetDistanceToPreviousPoint = d;
    }

    public void clearVelocity() {
        this.velocity.setComponents(0.0, 0.0);
    }
}

