/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.ProteinAttachmentStateMachine;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public abstract class Protein
extends MobileBiomolecule {
    public final BooleanProperty fullGrown = new BooleanProperty(false);
    private double fullSizeProportion = 0.0;

    protected Protein(GeneExpressionModel geneExpressionModel, Shape shape, Color color) {
        super(geneExpressionModel, shape, color);
    }

    protected AttachmentStateMachine createAttachmentStateMachine() {
        return new ProteinAttachmentStateMachine(this);
    }

    public void setFullSizeProportion(double d) {
        assert (d >= 0.0 && d <= 1.0);
        if (this.fullSizeProportion != d) {
            this.fullSizeProportion = d;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getPosition().getX(), this.getPosition().getY());
            Shape shape = this.getUntranslatedShape(d);
            this.shapeProperty.set(affineTransform.createTransformedShape(shape));
        }
    }

    public double getFullSizeProportion() {
        return this.fullSizeProportion;
    }

    protected abstract Shape getUntranslatedShape(double var1);

    public Shape getFullyGrownShape() {
        return this.getUntranslatedShape(1.0);
    }

    public abstract Protein createInstance();

    public void release() {
        this.attachmentStateMachine.setState(new AttachmentState.GenericUnattachedAndAvailableState());
        this.fullGrown.set(true);
    }

    public abstract void setAttachmentPointPosition(Vector2D var1);
}

