/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShapeChangingModelElement {
    protected final Property<Shape> shapeProperty;

    public ShapeChangingModelElement(Shape shape) {
        this.shapeProperty = new Property<Shape>(shape);
    }

    public Shape getShape() {
        return this.shapeProperty.get();
    }

    public void addShapeChangeObserver(VoidFunction1<Shape> voidFunction1) {
        this.shapeProperty.addObserver(voidFunction1);
    }

    public void translate(Vector2D vector2D) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(vector2D.getX(), vector2D.getY());
        this.shapeProperty.set(affineTransform.createTransformedShape(this.shapeProperty.get()));
    }

    public void setPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX(), vector2D.getY());
    }

    public void setPosition(double d, double d2) {
        if (d != this.getPosition().getX() || d2 != this.getPosition().getY()) {
            this.translate(new Vector2D(d - this.shapeProperty.get().getBounds2D().getCenterX(), d2 - this.shapeProperty.get().getBounds2D().getCenterY()));
        }
    }

    public Vector2D getPosition() {
        return new Vector2D(this.shapeProperty.get().getBounds2D().getCenterX(), this.shapeProperty.get().getBounds2D().getCenterY());
    }
}

