/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.PointMass;
import edu.colorado.phet.geneexpressionbasics.common.model.ShapeSegment;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WindingBiomolecule
extends MobileBiomolecule {
    private static final Color NOMINAL_COLOR = new Color(0, 0, 0, 0);
    protected PointMass firstShapeDefiningPoint = null;
    protected PointMass lastShapeDefiningPoint = null;
    public final EnhancedObservableList<ShapeSegment> shapeSegments = new EnhancedObservableList();

    protected WindingBiomolecule(GeneExpressionModel geneExpressionModel, Shape shape, Vector2D vector2D) {
        super(geneExpressionModel, shape, NOMINAL_COLOR);
        this.lastShapeDefiningPoint = this.firstShapeDefiningPoint = new PointMass(vector2D, 0.0);
    }

    private static void runSpringAlgorithm(PointMass pointMass, PointMass pointMass2, Rectangle2D rectangle2D) {
        PointMass pointMass3;
        assert (pointMass != null);
        if (pointMass == null) {
            return;
        }
        pointMass.setPosition(rectangle2D.getMinX(), rectangle2D.getMinY() + rectangle2D.getHeight());
        if (pointMass == pointMass2) {
            return;
        }
        pointMass2.setPosition(rectangle2D.getMaxX(), rectangle2D.getMinY());
        for (pointMass3 = pointMass; pointMass3 != null; pointMass3 = pointMass3.getNextPointMass()) {
            pointMass3.clearVelocity();
        }
        double d = 2.0;
        double d2 = 1.0;
        double d3 = 0.25;
        double d4 = 0.025;
        int n = 20;
        for (int i = 0; i < n; ++i) {
            PointMass pointMass4 = pointMass;
            for (pointMass3 = pointMass.getNextPointMass(); pointMass3 != null; pointMass3 = pointMass3.getNextPointMass()) {
                if (pointMass3.getNextPointMass() != null) {
                    PointMass pointMass5 = pointMass3.getNextPointMass();
                    Vector2D vector2D = new Vector2D(pointMass4.getPosition()).minus(new Vector2D(pointMass3.getPosition()));
                    if (vector2D.magnitude() == 0.0) {
                        vector2D = new Vector2D(1.0, 1.0);
                    }
                    double d5 = -d * (pointMass3.getTargetDistanceToPreviousPoint() - pointMass3.distance(pointMass4));
                    Vector2D vector2D2 = vector2D.normalized().times(d5);
                    Vector2D vector2D3 = new Vector2D(pointMass5.getPosition()).minus(new Vector2D(pointMass3.getPosition()));
                    if (vector2D3.magnitude() == 0.0) {
                        vector2D3 = new Vector2D(-1.0, -1.0);
                    }
                    double d6 = -d * (pointMass3.getTargetDistanceToPreviousPoint() - pointMass3.distance(pointMass5));
                    Vector2D vector2D4 = vector2D3.normalized().times(d6);
                    Vector2D vector2D5 = pointMass3.getVelocity().times(-d2);
                    Vector2D vector2D6 = vector2D2.plus(vector2D4).plus(vector2D5);
                    Vector2D vector2D7 = vector2D6.times(1.0 / d3);
                    pointMass3.setAcceleration(vector2D7);
                    pointMass3.update(d4);
                }
                pointMass4 = pointMass3;
            }
        }
    }

    private PointMass getFirstEnclosedPoint(DoubleRange doubleRange) {
        PointMass pointMass = this.firstShapeDefiningPoint;
        for (double d = 0.0; !(pointMass == null || d >= doubleRange.getMin() && d < doubleRange.getMax()); d += (pointMass = pointMass.getNextPointMass()) != null ? pointMass.getTargetDistanceToPreviousPoint() : 0.0) {
        }
        return pointMass;
    }

    private PointMass getLastEnclosedPoint(DoubleRange doubleRange) {
        double d;
        PointMass pointMass = this.firstShapeDefiningPoint;
        for (d = 0.0; !(pointMass == null || d >= doubleRange.getMin() && d < doubleRange.getMax()); d += (pointMass = pointMass.getNextPointMass()) != null ? pointMass.getTargetDistanceToPreviousPoint() : 0.0) {
        }
        if (pointMass != null) {
            while (pointMass.getNextPointMass() != null && pointMass.getNextPointMass().getTargetDistanceToPreviousPoint() + d < doubleRange.getMax()) {
                pointMass = pointMass.getNextPointMass();
                d += pointMass.getTargetDistanceToPreviousPoint();
            }
        }
        if (pointMass == null) {
            System.out.println("No last point.");
        }
        return pointMass;
    }

    public void addLength(double d) {
        if (this.firstShapeDefiningPoint == this.lastShapeDefiningPoint) {
            this.addPointToEnd(this.lastShapeDefiningPoint.getPosition(), d);
        } else if (this.lastShapeDefiningPoint.getTargetDistanceToPreviousPoint() < 50.0) {
            double d2 = this.lastShapeDefiningPoint.getTargetDistanceToPreviousPoint();
            if (d2 + d <= 50.0) {
                this.lastShapeDefiningPoint.setTargetDistanceToPreviousPoint(d2 + d);
            } else {
                this.lastShapeDefiningPoint.setTargetDistanceToPreviousPoint(50.0);
                assert (d - (50.0 - d2) > 0.0);
                this.addPointToEnd(this.lastShapeDefiningPoint.getPosition(), d - (50.0 - d2));
            }
        } else {
            this.addPointToEnd(this.lastShapeDefiningPoint.getPosition(), d);
        }
        this.getLastShapeSegment().add(d, this.shapeSegments);
        this.realignSegmentsFromEnd();
        this.windPointsThroughSegments();
    }

    protected void windPointsThroughSegments() {
        assert (this.shapeSegments.size() > 0);
        double d = 0.0;
        for (ShapeSegment shapeSegment : this.shapeSegments) {
            DoubleRange doubleRange;
            if (shapeSegment != this.getLastShapeSegment()) {
                doubleRange = new DoubleRange(d, d + shapeSegment.getContainedLength());
            } else {
                doubleRange = new DoubleRange(d, Double.POSITIVE_INFINITY);
                double d2 = this.getTotalLengthInShapeSegments();
                if (Math.abs(this.getLength() - d2) > 1.0) {
                    System.out.println(this.getClass().getName() + " Warning: Larger than expected difference between mRNA length and shape segment length.");
                }
            }
            PointMass pointMass = this.getFirstEnclosedPoint(doubleRange);
            PointMass pointMass2 = this.getLastEnclosedPoint(doubleRange);
            if (pointMass == null) continue;
            if (shapeSegment.isFlat()) {
                this.positionPointsInLine(pointMass, pointMass2, shapeSegment.getUpperLeftCornerPos());
            } else {
                this.randomizePointPositionsInRectangle(pointMass, pointMass2, shapeSegment.getBounds());
                WindingBiomolecule.runSpringAlgorithm(pointMass, pointMass2, shapeSegment.getBounds());
            }
            d += shapeSegment.getContainedLength();
        }
        this.shapeProperty.set(BioShapeUtils.createCurvyLineFromPoints(this.getPointList()));
    }

    private double getTotalLengthInShapeSegments() {
        double d = 0.0;
        for (ShapeSegment shapeSegment : this.shapeSegments) {
            d += shapeSegment.getContainedLength();
        }
        return d;
    }

    private void positionPointsInLine(PointMass pointMass, PointMass pointMass2, Vector2D vector2D) {
        PointMass pointMass3 = pointMass;
        double d = 0.0;
        while (pointMass3 != pointMass2 && pointMass3 != null) {
            pointMass3.setPosition(vector2D.getX() + d, vector2D.getY());
            pointMass3 = pointMass3.getNextPointMass();
            d += pointMass3 != null ? pointMass3.getTargetDistanceToPreviousPoint() : 0.0;
        }
        if (pointMass3 == null) {
            System.out.println(this.getClass().getName() + " Error: Last point not found when positioning points.");
            assert (false);
        } else {
            pointMass3.setPosition(vector2D.getX() + d, vector2D.getY());
        }
    }

    private void randomizePointPositionsInRectangle(PointMass pointMass, PointMass pointMass2, Rectangle2D rectangle2D) {
        assert (rectangle2D.getHeight() != 0.0);
        assert (pointMass != null);
        if (pointMass == null) {
            return;
        }
        pointMass.setPosition(rectangle2D.getMinX(), rectangle2D.getMinY() + rectangle2D.getHeight());
        if (pointMass == pointMass2) {
            return;
        }
        pointMass2.setPosition(rectangle2D.getMaxX(), rectangle2D.getMinY());
        Random random = new Random(8L);
        PointMass pointMass3 = pointMass;
        do {
            pointMass3.setPosition(rectangle2D.getMinX() + random.nextDouble() * rectangle2D.getWidth(), rectangle2D.getMinY() + random.nextDouble() * rectangle2D.getHeight());
        } while ((pointMass3 = pointMass3.getNextPointMass()) != pointMass2 && pointMass3 != null);
    }

    protected void realignSegmentsFromEnd() {
        ArrayList<ShapeSegment> arrayList = new ArrayList<ShapeSegment>(this.shapeSegments);
        Collections.reverse(arrayList);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            arrayList.get(i + 1).setLowerRightCornerPos(arrayList.get(i).getUpperLeftCornerPos());
        }
    }

    protected ShapeSegment getLastShapeSegment() {
        return (ShapeSegment)this.shapeSegments.get(this.shapeSegments.size() - 1);
    }

    private void addPointToEnd(Vector2D vector2D, double d) {
        PointMass pointMass = new PointMass(vector2D, d);
        this.lastShapeDefiningPoint.setNextPointMass(pointMass);
        pointMass.setPreviousPointMass(this.lastShapeDefiningPoint);
        this.lastShapeDefiningPoint = pointMass;
    }

    private List<Point2D> getPointList() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        for (PointMass pointMass = this.firstShapeDefiningPoint; pointMass != null; pointMass = pointMass.getNextPointMass()) {
            arrayList.add(pointMass.getPosition().toPoint2D());
        }
        return arrayList;
    }

    public double getLength() {
        double d = 0.0;
        for (PointMass pointMass = this.firstShapeDefiningPoint.getNextPointMass(); pointMass != null; pointMass = pointMass.getNextPointMass()) {
            d += pointMass.getTargetDistanceToPreviousPoint();
        }
        return d;
    }

    public void setLowerRightPosition(Vector2D vector2D) {
        this.getLastShapeSegment().setLowerRightCornerPos(vector2D);
        this.realignSegmentsFromEnd();
    }

    public void setLowerRightPosition(double d, double d2) {
        this.setLowerRightPosition(new Vector2D(d, d2));
    }

    protected void realignSegmentsFrom(ShapeSegment shapeSegment) {
        if (this.shapeSegments.indexOf(shapeSegment) == -1) {
            System.out.println(this.getClass().getName() + " Warning: Ignoring attempt to align to segment that is not on the list.");
            assert (false);
            return;
        }
        ShapeSegment shapeSegment2 = shapeSegment;
        ShapeSegment shapeSegment3 = this.shapeSegments.getNextItem(shapeSegment2);
        while (shapeSegment3 != null) {
            shapeSegment3.setUpperLeftCornerPosition(shapeSegment2.getLowerRightCornerPos());
            shapeSegment2 = shapeSegment3;
            shapeSegment3 = this.shapeSegments.getNextItem(shapeSegment2);
        }
        shapeSegment2 = shapeSegment;
        ShapeSegment shapeSegment4 = this.shapeSegments.getPreviousItem(shapeSegment2);
        while (shapeSegment4 != null) {
            shapeSegment4.setLowerRightCornerPos(shapeSegment2.getUpperLeftCornerPos());
            shapeSegment2 = shapeSegment4;
            shapeSegment4 = this.shapeSegments.getPreviousItem(shapeSegment2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnhancedObservableList<T>
    extends ObservableList<T> {
        public T getNextItem(T t) {
            int n = this.indexOf(t);
            if (n == -1) {
                throw new IllegalArgumentException("Given item not on list");
            }
            if (n == this.size() - 1) {
                return null;
            }
            return this.get(n + 1);
        }

        public T getPreviousItem(T t) {
            int n = this.indexOf(t);
            if (n == -1) {
                throw new IllegalArgumentException("Given item not on list");
            }
            if (n == 0) {
                return null;
            }
            return this.get(n - 1);
        }

        public void insertAfter(T t, T t2) {
            if (!this.contains(t)) {
                throw new IllegalArgumentException("Given item not on list");
            }
            this.add(this.indexOf(t) + 1, t2);
        }

        public void insertBefore(T t, T t2) {
            if (!this.contains(t)) {
                throw new IllegalArgumentException("Given item not on list");
            }
            this.add(this.indexOf(t), t2);
        }
    }
}

