/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.GenericAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.FollowAttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MeanderToDestinationMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.RandomWalkMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.WanderInGeneralDirectionMotionStrategy;
import java.awt.geom.Point2D;

public abstract class AttachmentState {
    public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
    }

    public void entered(AttachmentStateMachine attachmentStateMachine) {
    }

    public static class GenericAttachedState
    extends AttachmentState {
        private double attachCountdownTime = 3.0;

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            GenericAttachmentStateMachine genericAttachmentStateMachine = (GenericAttachmentStateMachine)attachmentStateMachine;
            assert (genericAttachmentStateMachine.attachmentSite != null);
            assert (genericAttachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == genericAttachmentStateMachine.biomolecule);
            this.attachCountdownTime -= d;
            if (this.attachCountdownTime <= 0.0) {
                genericAttachmentStateMachine.detach();
                genericAttachmentStateMachine.biomolecule.setMotionStrategy(new WanderInGeneralDirectionMotionStrategy(genericAttachmentStateMachine.biomolecule.getDetachDirection(), genericAttachmentStateMachine.biomolecule.motionBoundsProperty));
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            this.attachCountdownTime = 3.0;
            attachmentStateMachine.biomolecule.setMotionStrategy(new FollowAttachmentSite(attachmentStateMachine.attachmentSite));
            attachmentStateMachine.biomolecule.movableByUser.set(false);
        }
    }

    public static class GenericMovingTowardsAttachmentState
    extends AttachmentState {
        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            GenericAttachmentStateMachine genericAttachmentStateMachine = (GenericAttachmentStateMachine)attachmentStateMachine;
            assert (genericAttachmentStateMachine.attachmentSite != null);
            assert (genericAttachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == genericAttachmentStateMachine.biomolecule);
            Point2D.Double double_ = new Point2D.Double(genericAttachmentStateMachine.attachmentSite.locationProperty.get().getX() - genericAttachmentStateMachine.destinationOffset.getX(), genericAttachmentStateMachine.attachmentSite.locationProperty.get().getY() - genericAttachmentStateMachine.destinationOffset.getY());
            if (genericAttachmentStateMachine.biomolecule.getPosition().distance(double_) < 1.0) {
                genericAttachmentStateMachine.setState(genericAttachmentStateMachine.attachedState);
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.movableByUser.set(true);
        }
    }

    public static class GenericUnattachedAndAvailableState
    extends AttachmentState {
        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            GenericAttachmentStateMachine genericAttachmentStateMachine = (GenericAttachmentStateMachine)attachmentStateMachine;
            assert (genericAttachmentStateMachine.attachmentSite == null);
            genericAttachmentStateMachine.attachmentSite = genericAttachmentStateMachine.biomolecule.proposeAttachments();
            if (genericAttachmentStateMachine.attachmentSite != null) {
                genericAttachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.set(genericAttachmentStateMachine.biomolecule);
                genericAttachmentStateMachine.biomolecule.setMotionStrategy(new MeanderToDestinationMotionStrategy(genericAttachmentStateMachine.attachmentSite.locationProperty, genericAttachmentStateMachine.biomolecule.motionBoundsProperty, genericAttachmentStateMachine.destinationOffset));
                genericAttachmentStateMachine.setState(genericAttachmentStateMachine.movingTowardsAttachmentState);
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new RandomWalkMotionStrategy(attachmentStateMachine.biomolecule.motionBoundsProperty));
            attachmentStateMachine.biomolecule.movableByUser.set(true);
        }
    }

    public static class GenericUnattachedButUnavailableState
    extends AttachmentState {
        private double detachCountdownTime = 3.0;

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            GenericAttachmentStateMachine genericAttachmentStateMachine = (GenericAttachmentStateMachine)attachmentStateMachine;
            assert (genericAttachmentStateMachine.attachmentSite == null);
            this.detachCountdownTime -= d;
            if (this.detachCountdownTime <= 0.0) {
                genericAttachmentStateMachine.setState(genericAttachmentStateMachine.unattachedAndAvailableState);
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            this.detachCountdownTime = 3.0;
            attachmentStateMachine.biomolecule.movableByUser.set(true);
        }
    }
}

