/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;

public abstract class AttachmentStateMachine {
    protected final MobileBiomolecule biomolecule;
    protected AttachmentSite attachmentSite = null;
    private AttachmentState attachmentState;
    protected final MutableVector2D destinationOffset = new MutableVector2D(0.0, 0.0);

    public AttachmentStateMachine(MobileBiomolecule mobileBiomolecule) {
        this.biomolecule = mobileBiomolecule;
    }

    public void stepInTime(double d) {
        this.attachmentState.stepInTime(this, d);
    }

    public boolean isAttached() {
        return this.attachmentSite != null && this.attachmentSite.isMoleculeAttached();
    }

    public boolean isMovingTowardAttachment() {
        return this.attachmentSite != null && !this.attachmentSite.isMoleculeAttached();
    }

    public abstract void detach();

    public void forceImmediateUnattachedAndAvailable() {
        System.out.println(this.getClass().getName() + "Warning: Unimplemented method called in base class.");
    }

    public void forceImmediateUnattachedButUnavailable() {
        System.out.println(this.getClass().getName() + "Warning: Unimplemented method called in base class.");
    }

    public void setState(AttachmentState attachmentState) {
        this.attachmentState = attachmentState;
        this.attachmentState.entered(this);
    }

    protected void setDestinationOffset(double d, double d2) {
        this.destinationOffset.setComponents(d, d2);
    }

    protected void setDestinationOffset(Vector2D vector2D) {
        this.setDestinationOffset(vector2D.getX(), vector2D.getY());
    }
}

