/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.RandomWalkMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.StillnessMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.WanderInGeneralDirectionMotionStrategy;

public class MessengerRnaAttachmentStateMachine
extends AttachmentStateMachine {
    private final MessengerRna messengerRna;
    private boolean fadeAwayWhenFormed;

    public MessengerRnaAttachmentStateMachine(MessengerRna messengerRna) {
        super(messengerRna);
        this.messengerRna = messengerRna;
        this.setState(new BeingSynthesizedState());
    }

    public void detach() {
        if (this.fadeAwayWhenFormed) {
            this.setState(new UnattachedAndFadingState());
        } else {
            this.setState(new DetachingFromPolymeraseState());
        }
    }

    public void forceImmediateUnattachedAndAvailable() {
        if (this.attachmentSite != null) {
            this.attachmentSite.attachedOrAttachingMolecule.set(null);
        }
        this.attachmentSite = null;
        this.setState(new WanderingAroundCytoplasmState());
    }

    public void setFadeAwayWhenFormed(boolean bl) {
        this.fadeAwayWhenFormed = bl;
    }

    public void attachedToRibosome() {
        this.setState(new BeingTranslatedState());
    }

    public void allRibosomesDetached() {
        this.setState(new WanderingAroundCytoplasmState());
    }

    public void attachToDestroyer() {
        this.setState(new BeingDestroyedState());
    }

    protected class BeingDestroyedState
    extends AttachmentState {
        protected BeingDestroyedState() {
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new StillnessMotionStrategy());
        }
    }

    protected class BeingSynthesizedState
    extends AttachmentState {
        protected BeingSynthesizedState() {
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new StillnessMotionStrategy());
        }
    }

    protected class BeingTranslatedState
    extends AttachmentState {
        protected BeingTranslatedState() {
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new StillnessMotionStrategy());
        }
    }

    protected class DetachingFromPolymeraseState
    extends AttachmentState {
        private double detachingCountdownTimer = 3.0;

        protected DetachingFromPolymeraseState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            this.detachingCountdownTimer -= d;
            if (this.detachingCountdownTimer <= 0.0) {
                MessengerRnaAttachmentStateMachine.this.setState(new WanderingAroundCytoplasmState());
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new WanderInGeneralDirectionMotionStrategy(new Vector2D(-0.5, 1.0), attachmentStateMachine.biomolecule.motionBoundsProperty));
            ((MessengerRnaAttachmentStateMachine)MessengerRnaAttachmentStateMachine.this).messengerRna.beingSynthesized.set(false);
        }
    }

    protected class UnattachedAndFadingState
    extends AttachmentState {
        private double preFadeCountdown = 5.0;

        protected UnattachedAndFadingState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            if (this.preFadeCountdown > 0.0) {
                this.preFadeCountdown -= d;
            } else {
                MessengerRnaAttachmentStateMachine.this.biomolecule.existenceStrength.set(Math.max(MessengerRnaAttachmentStateMachine.this.biomolecule.existenceStrength.get() - d / 2.0, 0.0));
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            assert (MessengerRnaAttachmentStateMachine.this.biomolecule.existenceStrength.get() == 1.0);
            this.preFadeCountdown = 5.0;
            attachmentStateMachine.biomolecule.setMotionStrategy(new WanderInGeneralDirectionMotionStrategy(new Vector2D(0.0, 0.75), attachmentStateMachine.biomolecule.motionBoundsProperty));
        }
    }

    protected class WanderingAroundCytoplasmState
    extends AttachmentState {
        protected WanderingAroundCytoplasmState() {
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.setMotionStrategy(new RandomWalkMotionStrategy(attachmentStateMachine.biomolecule.motionBoundsProperty));
        }
    }
}

