/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaSeparation;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.GenericAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.DriftThenTeleportMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MoveDirectlyToDestinationMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.RandomWalkMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.WanderInGeneralDirectionMotionStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RnaPolymeraseAttachmentStateMachine
extends GenericAttachmentStateMachine {
    private static final Random RAND = new Random();
    private final AttachmentState attachedAndWanderingState = new AttachedToBasePair();
    private final AttachmentState attachedAndConformingState = new AttachedAndConformingState();
    private final AttachmentState attachedAndTranscribingState = new AttachedAndTranscribingState();
    private final AttachmentState attachedAndDeconformingState = new AttachedAndDeconformingState();
    private final RnaPolymerase rnaPolymerase;
    private final DnaSeparation dnaStrandSeparation;
    private final AttachmentSite transcribingAttachmentSite = new AttachmentSite(new Vector2D(0.0, 0.0), 1.0);
    private Property<Double> detachFromDnaThreshold = new Property<Double>(1.0);
    private boolean recycleMode = false;
    private final List<Rectangle2D> recycleReturnZones = new ArrayList<Rectangle2D>();

    public RnaPolymeraseAttachmentStateMachine(RnaPolymerase rnaPolymerase) {
        super(rnaPolymerase);
        this.rnaPolymerase = rnaPolymerase;
        this.attachedState = this.attachedAndWanderingState;
        this.dnaStrandSeparation = new DnaSeparation(rnaPolymerase.getPosition().getX(), rnaPolymerase.getShape().getBounds2D().getHeight() * 0.9);
        this.transcribingAttachmentSite.attachedOrAttachingMolecule.set(rnaPolymerase);
    }

    public void setRecycleMode(boolean bl) {
        this.recycleMode = bl;
    }

    public void addRecycleReturnZone(Rectangle2D rectangle2D) {
        this.recycleReturnZones.add(rectangle2D);
    }

    private static double calculateProbabilityOfDetachment(double d, double d2) {
        return 1.0 - Math.exp(-0.693 * d2 / RnaPolymeraseAttachmentStateMachine.calculateHalfLifeFromAffinity(d));
    }

    private static double calculateHalfLifeFromAffinity(double d) {
        return 1.5 * (d / (1.0 - d));
    }

    private static boolean pointContainedInBoundsList(Point2D point2D, List<Rectangle2D> list) {
        for (Rectangle2D rectangle2D : list) {
            if (!rectangle2D.contains(point2D)) continue;
            return true;
        }
        return false;
    }

    protected class AttachedAndConformingState
    extends AttachmentState {
        private double conformationalChangeAmount;

        protected AttachedAndConformingState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == RnaPolymeraseAttachmentStateMachine.this.biomolecule);
            this.conformationalChangeAmount = Math.min(this.conformationalChangeAmount + 1.0 * d, 1.0);
            RnaPolymeraseAttachmentStateMachine.this.biomolecule.changeConformation(this.conformationalChangeAmount);
            RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation.setProportionOfTargetAmount(this.conformationalChangeAmount);
            if (this.conformationalChangeAmount == 1.0) {
                RnaPolymeraseAttachmentStateMachine.this.attachedState = RnaPolymeraseAttachmentStateMachine.this.attachedAndTranscribingState;
                RnaPolymeraseAttachmentStateMachine.this.setState(RnaPolymeraseAttachmentStateMachine.this.attachedState);
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.movableByUser.set(false);
            RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation.setXPos(RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getPosition().getX());
            RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getModel().getDnaMolecule().addSeparation(RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation);
            this.conformationalChangeAmount = 0.0;
        }
    }

    protected class AttachedAndDeconformingState
    extends AttachmentState {
        private double conformationalChangeAmount;

        protected AttachedAndDeconformingState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == RnaPolymeraseAttachmentStateMachine.this.biomolecule);
            this.conformationalChangeAmount = Math.max(this.conformationalChangeAmount - 1.0 * d, 0.0);
            RnaPolymeraseAttachmentStateMachine.this.biomolecule.changeConformation(this.conformationalChangeAmount);
            RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation.setProportionOfTargetAmount(this.conformationalChangeAmount);
            if (this.conformationalChangeAmount == 0.0) {
                RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getModel().getDnaMolecule().removeSeparation(RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation);
                attachmentStateMachine.biomolecule.attachedToDna.set(false);
                RnaPolymeraseAttachmentStateMachine.this.attachedState = RnaPolymeraseAttachmentStateMachine.this.attachedAndWanderingState;
                RnaPolymeraseAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(null);
                RnaPolymeraseAttachmentStateMachine.this.attachmentSite = null;
                if (RnaPolymeraseAttachmentStateMachine.this.recycleMode) {
                    RnaPolymeraseAttachmentStateMachine.this.setState(new BeingRecycledState(RnaPolymeraseAttachmentStateMachine.this.recycleReturnZones));
                } else {
                    RnaPolymeraseAttachmentStateMachine.this.forceImmediateUnattachedButUnavailable();
                }
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.movableByUser.set(false);
            this.conformationalChangeAmount = 1.0;
        }
    }

    protected class AttachedAndTranscribingState
    extends AttachmentState {
        private Vector2D endOfGene = null;
        private MessengerRna messengerRna;

        protected AttachedAndTranscribingState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == RnaPolymeraseAttachmentStateMachine.this.biomolecule);
            this.messengerRna.addLength(1000.0 * d);
            this.messengerRna.setLowerRightPosition(RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getPosition().getX() + RnaPolymerase.MESSENGER_RNA_GENERATION_OFFSET.getX(), RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getPosition().getY() + RnaPolymerase.MESSENGER_RNA_GENERATION_OFFSET.getY());
            RnaPolymeraseAttachmentStateMachine.this.dnaStrandSeparation.setXPos(RnaPolymeraseAttachmentStateMachine.this.rnaPolymerase.getPosition().getX());
            for (MobileBiomolecule mobileBiomolecule : attachmentStateMachine.biomolecule.getModel().getOverlappingBiomolecules(attachmentStateMachine.biomolecule.getShape())) {
                if (!(mobileBiomolecule.getPosition().getX() > attachmentStateMachine.biomolecule.getPosition().getX()) || !((Boolean)mobileBiomolecule.attachedToDna.get()).booleanValue()) continue;
                mobileBiomolecule.forceDetach();
            }
            if (RnaPolymeraseAttachmentStateMachine.this.biomolecule.getPosition().equals(this.endOfGene)) {
                RnaPolymeraseAttachmentStateMachine.this.attachedState = RnaPolymeraseAttachmentStateMachine.this.attachedAndDeconformingState;
                RnaPolymeraseAttachmentStateMachine.this.setState(RnaPolymeraseAttachmentStateMachine.this.attachedState);
                this.messengerRna.releaseFromPolymerase();
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.movableByUser.set(false);
            Gene gene = RnaPolymeraseAttachmentStateMachine.this.biomolecule.getModel().getDnaMolecule().getGeneAtLocation(RnaPolymeraseAttachmentStateMachine.this.biomolecule.getPosition());
            assert (gene != null);
            this.endOfGene = new Vector2D(gene.getEndX(), 0.0);
            attachmentStateMachine.biomolecule.setMotionStrategy(new MoveDirectlyToDestinationMotionStrategy(new Property<Vector2D>(new Vector2D(this.endOfGene)), RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty, new Vector2D(0.0, 0.0), 1000.0));
            this.messengerRna = new MessengerRna(RnaPolymeraseAttachmentStateMachine.this.biomolecule.getModel(), gene.getProteinPrototype(), RnaPolymeraseAttachmentStateMachine.this.biomolecule.getPosition().plus(RnaPolymerase.MESSENGER_RNA_GENERATION_OFFSET));
            RnaPolymeraseAttachmentStateMachine.this.biomolecule.spawnMessengerRna(this.messengerRna);
            RnaPolymeraseAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(null);
            ((RnaPolymeraseAttachmentStateMachine)RnaPolymeraseAttachmentStateMachine.this).transcribingAttachmentSite.attachedOrAttachingMolecule.set(attachmentStateMachine.biomolecule);
            RnaPolymeraseAttachmentStateMachine.this.attachmentSite = RnaPolymeraseAttachmentStateMachine.this.transcribingAttachmentSite;
        }
    }

    protected class AttachedToBasePair
    extends AttachmentState {
        private boolean transcribe = false;

        protected AttachedToBasePair() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == attachmentStateMachine.biomolecule);
            if (this.transcribe) {
                RnaPolymeraseAttachmentStateMachine.this.attachedState = RnaPolymeraseAttachmentStateMachine.this.attachedAndConformingState;
                RnaPolymeraseAttachmentStateMachine.this.setState(RnaPolymeraseAttachmentStateMachine.this.attachedState);
                RnaPolymeraseAttachmentStateMachine.this.detachFromDnaThreshold.reset();
            } else if (RAND.nextDouble() > 1.0 - RnaPolymeraseAttachmentStateMachine.calculateProbabilityOfDetachment(RnaPolymeraseAttachmentStateMachine.this.attachmentSite.getAffinity(), d)) {
                if (RAND.nextDouble() > (Double)RnaPolymeraseAttachmentStateMachine.this.detachFromDnaThreshold.get()) {
                    this.detachFromDnaMolecule(attachmentStateMachine);
                } else {
                    List<AttachmentSite> list = RnaPolymeraseAttachmentStateMachine.this.biomolecule.getModel().getDnaMolecule().getAdjacentAttachmentSites((RnaPolymerase)RnaPolymeraseAttachmentStateMachine.this.biomolecule, attachmentStateMachine.attachmentSite);
                    for (AttachmentSite attachmentSite : new ArrayList<AttachmentSite>(list)) {
                        if (!attachmentSite.isMoleculeAttached() && RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty.get().testIfInMotionBounds(RnaPolymeraseAttachmentStateMachine.this.biomolecule.getShape(), attachmentSite.locationProperty.get())) continue;
                        list.remove(attachmentSite);
                    }
                    Collections.shuffle(list);
                    if (list.size() == 0) {
                        this.detachFromDnaMolecule(attachmentStateMachine);
                    } else {
                        RnaPolymeraseAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(null);
                        RnaPolymeraseAttachmentStateMachine.this.attachmentSite = list.get(0);
                        assert (RnaPolymeraseAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.get() == null);
                        RnaPolymeraseAttachmentStateMachine.this.attachmentSite.attachedOrAttachingMolecule.set(RnaPolymeraseAttachmentStateMachine.this.biomolecule);
                        RnaPolymeraseAttachmentStateMachine.this.setState(RnaPolymeraseAttachmentStateMachine.this.movingTowardsAttachmentState);
                        RnaPolymeraseAttachmentStateMachine.this.biomolecule.setMotionStrategy(new MoveDirectlyToDestinationMotionStrategy(RnaPolymeraseAttachmentStateMachine.this.attachmentSite.locationProperty, RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty, new Vector2D(0.0, 0.0), 200.0));
                        RnaPolymeraseAttachmentStateMachine.this.detachFromDnaThreshold.set((Double)RnaPolymeraseAttachmentStateMachine.this.detachFromDnaThreshold.get() * Math.pow(0.5, 0.15));
                    }
                }
            }
        }

        private void detachFromDnaMolecule(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.set(null);
            attachmentStateMachine.attachmentSite = null;
            attachmentStateMachine.setState(RnaPolymeraseAttachmentStateMachine.this.unattachedButUnavailableState);
            RnaPolymeraseAttachmentStateMachine.this.biomolecule.setMotionStrategy(new WanderInGeneralDirectionMotionStrategy(RnaPolymeraseAttachmentStateMachine.this.biomolecule.getDetachDirection(), RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty));
            RnaPolymeraseAttachmentStateMachine.this.detachFromDnaThreshold.reset();
            attachmentStateMachine.biomolecule.attachedToDna.set(false);
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            this.transcribe = RnaPolymeraseAttachmentStateMachine.this.attachmentSite.getAffinity() > 0.05 && RAND.nextDouble() < RnaPolymeraseAttachmentStateMachine.this.attachmentSite.getAffinity();
            attachmentStateMachine.biomolecule.movableByUser.set(true);
            attachmentStateMachine.biomolecule.attachedToDna.set(true);
            attachmentStateMachine.biomolecule.attachedToDna.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BeingRecycledState
    extends AttachmentState {
        private final List<Rectangle2D> recycleReturnZones;

        public BeingRecycledState(List<Rectangle2D> list) {
            this.recycleReturnZones = list;
        }

        @Override
        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite == null);
            if (RnaPolymeraseAttachmentStateMachine.pointContainedInBoundsList(attachmentStateMachine.biomolecule.getPosition().toPoint2D(), RnaPolymeraseAttachmentStateMachine.this.recycleReturnZones)) {
                attachmentStateMachine.biomolecule.setMotionStrategy(new RandomWalkMotionStrategy(RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty));
                attachmentStateMachine.setState(RnaPolymeraseAttachmentStateMachine.this.unattachedAndAvailableState);
            }
        }

        @Override
        public void entered(AttachmentStateMachine attachmentStateMachine) {
            attachmentStateMachine.biomolecule.movableByUser.set(false);
            attachmentStateMachine.biomolecule.setMotionStrategy(new DriftThenTeleportMotionStrategy(new Vector2D(0.0, RAND.nextBoolean() ? 1.0 : -1.0), this.recycleReturnZones, RnaPolymeraseAttachmentStateMachine.this.biomolecule.motionBoundsProperty));
        }
    }
}

