/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriftThenTeleportMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private final List<Rectangle2D> destinationZones;
    private double preFadeCountdown = 1.5;
    private final Vector2D velocityXY;
    private double velocityZ = 0.0;

    public DriftThenTeleportMotionStrategy(Vector2D vector2D, List<Rectangle2D> list, Property<MotionBounds> property) {
        this.destinationZones = list;
        property.addObserver(new VoidFunction1<MotionBounds>(){

            @Override
            public void apply(MotionBounds motionBounds) {
                DriftThenTeleportMotionStrategy.this.motionBounds = motionBounds;
            }
        });
        this.velocityXY = vector2D.times(250.0);
        this.velocityZ = -1.0;
    }

    @Override
    public Vector2D getNextLocation(Vector2D vector2D, Shape shape, double d) {
        Point3D point3D = this.getNextLocation3D(new Point3D.Double(vector2D.getX(), vector2D.getY(), 0.0), shape, d);
        return new Vector2D(point3D.getX(), point3D.getY());
    }

    @Override
    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        if (point3D.getZ() <= -1.0) {
            Point2D point2D = this.generateRandomLocationInBounds(this.destinationZones, shape);
            return new Point3D.Double(point2D.getX(), point2D.getY(), -1.0);
        }
        Vector2D vector2D = this.motionBounds.testIfInMotionBounds(shape, this.velocityXY, d) ? this.velocityXY.times(d) : new Vector2D(0.0, 0.0);
        double d2 = 0.0;
        if (this.preFadeCountdown > 0.0) {
            this.preFadeCountdown -= d;
        } else {
            d2 = this.velocityZ * d;
        }
        return new Point3D.Double(point3D.getX() + vector2D.getX(), point3D.getY() + vector2D.getY(), MathUtil.clamp(-1.0, point3D.getZ() + d2, 0.0));
    }

    private Point2D generateRandomLocationInBounds(List<Rectangle2D> list, Shape shape) {
        Rectangle2D rectangle2D = list.get(RAND.nextInt(list.size()));
        double d = rectangle2D.getWidth() - shape.getBounds2D().getWidth();
        double d2 = rectangle2D.getHeight() - shape.getBounds2D().getHeight();
        if (d <= 0.0 || d2 <= 0.0) {
            System.out.println(this.getClass().getName() + " - Warning: Bounds cannot contain shape.");
            return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        return new Point2D.Double(rectangle2D.getX() + shape.getBounds2D().getWidth() / 2.0 + RAND.nextDouble() * d, rectangle2D.getY() + shape.getBounds2D().getHeight() / 2.0 + RAND.nextDouble() * d2);
    }
}

