/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MoveDirectlyToDestinationMotionStrategy;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.RandomWalkMotionStrategy;
import java.awt.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanderToDestinationMotionStrategy
extends MotionStrategy {
    private final MotionStrategy randomWalkMotionStrategy;
    private final MotionStrategy directToDestinationMotionStrategy;
    private final Property<Vector2D> destinationProperty;

    public MeanderToDestinationMotionStrategy(Property<Vector2D> property, Property<MotionBounds> property2, AbstractVector2D abstractVector2D) {
        this.randomWalkMotionStrategy = new RandomWalkMotionStrategy(property2);
        this.directToDestinationMotionStrategy = new MoveDirectlyToDestinationMotionStrategy(property, property2, abstractVector2D, 750.0);
        this.destinationProperty = property;
    }

    @Override
    public Vector2D getNextLocation(Vector2D vector2D, Shape shape, double d) {
        Point3D point3D = this.getNextLocation3D(new Point3D.Double(vector2D.getX(), vector2D.getY(), 0.0), shape, d);
        return new Vector2D(point3D.getX(), point3D.getY());
    }

    @Override
    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        if (shape.getBounds2D().contains(this.destinationProperty.get().toPoint2D())) {
            return this.directToDestinationMotionStrategy.getNextLocation3D(point3D, shape, d);
        }
        Point3D point3D2 = this.randomWalkMotionStrategy.getNextLocation3D(point3D, shape, d * 0.6);
        return this.directToDestinationMotionStrategy.getNextLocation3D(point3D2, shape, d * 0.4);
    }
}

