/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class MotionStrategy {
    protected MotionBounds motionBounds = new MotionBounds();

    public abstract Vector2D getNextLocation(Vector2D var1, Shape var2, double var3);

    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        Vector2D vector2D = this.getNextLocation(new Vector2D(point3D.getX(), point3D.getY()), shape, d);
        return new Point3D.Double(vector2D.getX(), vector2D.getY(), 0.0);
    }

    protected Vector2D getMotionVectorForBounce(Shape shape, Vector2D vector2D, double d, double d2) {
        AffineTransform affineTransform = this.getMotionTransform(vector2D, d);
        assert (!this.motionBounds.inBounds(affineTransform.createTransformedShape(shape)));
        Vector2D vector2D2 = new Vector2D(-vector2D.getX(), vector2D.getY());
        AffineTransform affineTransform2 = this.getMotionTransform(vector2D2, d);
        if (this.motionBounds.inBounds(affineTransform2.createTransformedShape(shape))) {
            return vector2D2;
        }
        Vector2D vector2D3 = new Vector2D(vector2D.getX(), -vector2D.getY());
        AffineTransform affineTransform3 = this.getMotionTransform(vector2D3, d);
        if (this.motionBounds.inBounds(affineTransform3.createTransformedShape(shape))) {
            return vector2D3;
        }
        Vector2D vector2D4 = new Vector2D(-vector2D.getX(), -vector2D.getY());
        AffineTransform affineTransform4 = this.getMotionTransform(vector2D4, d);
        if (this.motionBounds.inBounds(affineTransform4.createTransformedShape(shape))) {
            return vector2D4;
        }
        Point2D.Double double_ = new Point2D.Double(this.motionBounds.getBounds().getBounds2D().getCenterX(), this.motionBounds.getBounds().getBounds2D().getCenterY());
        MutableVector2D mutableVector2D = new MutableVector2D(((Point2D)double_).getX() - shape.getBounds2D().getCenterX(), ((Point2D)double_).getY() - shape.getBounds2D().getCenterY());
        mutableVector2D.scale(d2 / mutableVector2D.magnitude());
        return new Vector2D(mutableVector2D);
    }

    private AffineTransform getMotionTransform(AbstractVector2D abstractVector2D, double d) {
        return AffineTransform.getTranslateInstance(abstractVector2D.getX() * d, abstractVector2D.getY() * d);
    }

    private static boolean rangesOverlap(DoubleRange doubleRange, DoubleRange doubleRange2) {
        return !(doubleRange.getMin() > doubleRange2.getMax()) && !(doubleRange.getMax() < doubleRange2.getMin());
    }

    private static double calculateDistanceBetweenRanges(DoubleRange doubleRange, DoubleRange doubleRange2) {
        double d = MotionStrategy.rangesOverlap(doubleRange, doubleRange2) ? 0.0 : (doubleRange.getMax() < doubleRange2.getMin() ? doubleRange2.getMin() - doubleRange.getMax() : doubleRange.getMin() - doubleRange2.getMax());
        return d;
    }

    protected static double getMinZ(Shape shape, Point2D point2D) {
        DoubleRange doubleRange = new DoubleRange(point2D.getY() - shape.getBounds2D().getHeight() / 2.0, point2D.getY() + shape.getBounds2D().getHeight() / 2.0);
        DoubleRange doubleRange2 = new DoubleRange(-100.0, 100.0);
        double d = -1.0;
        double d2 = MotionStrategy.calculateDistanceBetweenRanges(doubleRange, doubleRange2);
        if (d2 < doubleRange.getLength() / 2.0) {
            d = -d2 / (doubleRange.getLength() / 2.0);
        }
        return d;
    }
}

