/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import java.awt.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveDirectlyToDestinationMotionStrategy
extends MotionStrategy {
    private final MutableVector2D velocityVector2D = new MutableVector2D(0.0, 0.0);
    private final Property<Vector2D> destinationProperty;
    private final AbstractVector2D offsetFromDestinationProperty;
    private final double scalarVelocity2D;

    public MoveDirectlyToDestinationMotionStrategy(Property<Vector2D> property, Property<MotionBounds> property2, AbstractVector2D abstractVector2D, double d) {
        this.destinationProperty = property;
        this.scalarVelocity2D = d;
        this.offsetFromDestinationProperty = abstractVector2D;
        property2.addObserver(new VoidFunction1<MotionBounds>(){

            @Override
            public void apply(MotionBounds motionBounds) {
                MoveDirectlyToDestinationMotionStrategy.this.motionBounds = motionBounds;
            }
        });
    }

    @Override
    public Vector2D getNextLocation(Vector2D vector2D, Shape shape, double d) {
        Point3D point3D = this.getNextLocation3D(new Point3D.Double(vector2D.getX(), vector2D.getY(), 0.0), shape, d);
        return new Vector2D(point3D.getX(), point3D.getY());
    }

    @Override
    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        Point3D.Double double_ = new Point3D.Double(this.destinationProperty.get().getX() - this.offsetFromDestinationProperty.getX(), this.destinationProperty.get().getY() - this.offsetFromDestinationProperty.getY(), 0.0);
        Vector2D vector2D = new Vector2D(this.destinationProperty.get().getX() - this.offsetFromDestinationProperty.getX(), this.destinationProperty.get().getY() - this.offsetFromDestinationProperty.getY());
        Vector2D vector2D2 = new Vector2D(point3D.getX(), point3D.getY());
        this.updateVelocityVector2D(vector2D2, new Vector2D(((Point3D)double_).getX(), ((Point3D)double_).getY()), this.scalarVelocity2D);
        double d2 = vector2D2.distance(this.destinationProperty.get());
        double d3 = d2 > 0.0 ? Math.min(Math.abs(point3D.getZ()) / (vector2D2.distance(this.destinationProperty.get()) / this.scalarVelocity2D), 10.0) : 10.0;
        if (this.motionBounds.inBounds(shape) && !this.motionBounds.testIfInMotionBounds(shape, this.velocityVector2D, d)) {
            System.out.println(this.getClass().getName() + " - Warning: Destination is causing some portion of shape to move out of bounds.");
        }
        double d4 = vector2D2.distance(vector2D);
        if (this.velocityVector2D.magnitude() * d > d4) {
            return double_;
        }
        return new Point3D.Double(point3D.getX() + this.velocityVector2D.getX() * d, point3D.getY() + this.velocityVector2D.getY() * d, MathUtil.clamp(-1.0, point3D.getZ() + d3 * d, 0.0));
    }

    private void updateVelocityVector2D(Vector2D vector2D, Vector2D vector2D2, double d) {
        if (vector2D.distance(vector2D2) == 0.0) {
            this.velocityVector2D.setComponents(0.0, 0.0);
        } else {
            this.velocityVector2D.setValue(new Vector2D(vector2D, vector2D2).getInstanceOfMagnitude(d));
        }
    }
}

