/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomWalkMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private double directionChangeCountdown = 0.0;
    private Vector2D currentMotionVector2D = new Vector2D(0.0, 0.0);
    private double currentZVelocity = 0.0;

    public RandomWalkMotionStrategy(Property<MotionBounds> property) {
        property.addObserver(new VoidFunction1<MotionBounds>(){

            @Override
            public void apply(MotionBounds motionBounds) {
                RandomWalkMotionStrategy.this.motionBounds = motionBounds;
            }
        });
    }

    @Override
    public Vector2D getNextLocation(Vector2D vector2D, Shape shape, double d) {
        Point3D point3D = this.getNextLocation3D(new Point3D.Double(vector2D.getX(), vector2D.getY(), 0.0), shape, d);
        return new Vector2D(point3D.getX(), point3D.getY());
    }

    @Override
    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        double d2;
        this.directionChangeCountdown -= d;
        if (this.directionChangeCountdown <= 0.0) {
            d2 = 200.0 + RAND.nextDouble() * 200.0;
            double d3 = Math.PI * 2 * RAND.nextDouble();
            this.currentMotionVector2D = Vector2D.createPolar(d2, d3);
            this.currentZVelocity = 0.3 + RAND.nextDouble() * 0.3;
            this.currentZVelocity = RAND.nextBoolean() ? -this.currentZVelocity : this.currentZVelocity;
            this.directionChangeCountdown = this.generateDirectionChangeCountdownValue();
        }
        if (!this.motionBounds.testIfInMotionBounds(shape, this.currentMotionVector2D, d)) {
            this.currentMotionVector2D = this.getMotionVectorForBounce(shape, this.currentMotionVector2D, d, 400.0);
            this.directionChangeCountdown = this.generateDirectionChangeCountdownValue();
        }
        d2 = RandomWalkMotionStrategy.getMinZ(shape, new Point2D.Double(point3D.getX(), point3D.getY()));
        return new Point3D.Double(point3D.getX() + this.currentMotionVector2D.getX() * d, point3D.getY() + this.currentMotionVector2D.getY() * d, MathUtil.clamp(d2, point3D.getZ() + this.currentZVelocity * d, 0.0));
    }

    private double generateDirectionChangeCountdownValue() {
        return 0.25 + RAND.nextDouble() * 0.55;
    }
}

