/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies;

import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionStrategy;
import java.awt.Shape;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WanderInGeneralDirectionMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private final Vector2D generalDirection;
    private double directionChangeCountdown = 0.0;
    private Vector2D currentMotionVector = new Vector2D(0.0, 0.0);

    public WanderInGeneralDirectionMotionStrategy(Vector2D vector2D, Property<MotionBounds> property) {
        property.addObserver(new VoidFunction1<MotionBounds>(){

            @Override
            public void apply(MotionBounds motionBounds) {
                WanderInGeneralDirectionMotionStrategy.this.motionBounds = motionBounds;
            }
        });
        this.generalDirection = vector2D;
    }

    @Override
    public Vector2D getNextLocation(Vector2D vector2D, Shape shape, double d) {
        this.directionChangeCountdown -= d;
        if (this.directionChangeCountdown <= 0.0) {
            double d2 = 100.0 + RAND.nextDouble() * 400.0;
            double d3 = (RAND.nextDouble() - 0.5) * Math.PI / 3.0;
            this.currentMotionVector = this.generalDirection.getInstanceOfMagnitude(d2).getRotatedInstance(d3);
            this.directionChangeCountdown = this.generateDirectionChangeCountdownValue();
        }
        if (!this.motionBounds.testIfInMotionBounds(shape, this.currentMotionVector, d)) {
            this.currentMotionVector = this.getMotionVectorForBounce(shape, this.currentMotionVector, d, 500.0);
            this.directionChangeCountdown = this.generateDirectionChangeCountdownValue();
        }
        return vector2D.plus(this.currentMotionVector.times(d));
    }

    @Override
    public Point3D getNextLocation3D(Point3D point3D, Shape shape, double d) {
        Vector2D vector2D = this.getNextLocation(new Vector2D(point3D.getX(), point3D.getY()), shape, d);
        return new Point3D.Double(vector2D.getX(), vector2D.getY(), point3D.getZ());
    }

    private double generateDirectionChangeCountdownValue() {
        return 0.25 + RAND.nextDouble() * 1.0;
    }
}

