/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;

class BiomoleculeDragHandler
extends PDragEventHandler {
    private final MobileBiomolecule biomolecule;
    private final PNode pNode;
    private final ModelViewTransform mvt;

    public BiomoleculeDragHandler(MobileBiomolecule mobileBiomolecule, PNode pNode, ModelViewTransform modelViewTransform) {
        this.biomolecule = mobileBiomolecule;
        this.pNode = pNode;
        this.mvt = modelViewTransform;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.biomolecule.userControlled.set(true);
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(this.pNode.getParent());
        Vector2D vector2D = this.mvt.viewToModelDelta(new Vector2D(pDimension));
        this.biomolecule.translate(vector2D);
    }

    protected void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        this.biomolecule.userControlled.set(false);
    }
}

