/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;

class GeneNode
extends PNode {
    private static final Font REGION_LABEL_FONT = new PhetFont(11);
    private static final Font GENE_LABEL_FONT = new PhetFont(16);

    public GeneNode(ModelViewTransform modelViewTransform, Gene gene, DnaMolecule dnaMolecule, String string, boolean bl) {
        double d = -modelViewTransform.modelToViewDeltaY(300.0);
        double d2 = modelViewTransform.modelToViewY(dnaMolecule.getLeftEdgePos().getY()) - d / 2.0;
        double d3 = modelViewTransform.modelToViewX(dnaMolecule.getBasePairXOffsetByIndex(gene.getRegulatoryRegion().getMin()));
        double d4 = modelViewTransform.modelToViewX(dnaMolecule.getBasePairXOffsetByIndex(gene.getRegulatoryRegion().getMax())) - d3;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d3, d2, d4, d, 15.0, 15.0);
        final PhetPPath phetPPath = new PhetPPath((Shape)double_, (Paint)gene.getRegulatoryRegionColor());
        this.addChild(phetPPath);
        HTMLNode hTMLNode = new HTMLNode(GeneExpressionBasicsResources.Strings.REGULATORY_REGION){
            {
                super(string);
                this.setFont(REGION_LABEL_FONT);
                this.setOffset(phetPPath.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().width / 2.0, phetPPath.getFullBoundsReference().getMaxY());
            }
        };
        this.addChild(hTMLNode);
        double d5 = modelViewTransform.modelToViewX(dnaMolecule.getBasePairXOffsetByIndex(gene.getTranscribedRegion().getMin()));
        double d6 = modelViewTransform.modelToViewX(dnaMolecule.getBasePairXOffsetByIndex(gene.getTranscribedRegion().getMax())) - d5;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(d5, d2, d6, d, 15.0, 15.0);
        final PhetPPath phetPPath2 = new PhetPPath((Shape)double_2, (Paint)gene.getTranscribedRegionColor());
        this.addChild(phetPPath2);
        HTMLNode hTMLNode2 = new HTMLNode(GeneExpressionBasicsResources.Strings.TRANSCRIBED_REGION){
            {
                super(string);
                this.setFont(REGION_LABEL_FONT);
                this.setOffset(phetPPath2.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().width / 2.0, phetPPath2.getFullBoundsReference().getMaxY());
            }
        };
        this.addChild(hTMLNode2);
        if (bl) {
            final DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(phetPPath.getFullBoundsReference().getMinX(), hTMLNode.getFullBoundsReference().getMaxY());
            doubleGeneralPath.lineToRelative(20.0, 20.0);
            doubleGeneralPath.lineTo(phetPPath2.getFullBoundsReference().getMaxX() - 20.0, hTMLNode2.getFullBoundsReference().getMaxY() + 20.0);
            doubleGeneralPath.lineToRelative(20.0, -20.0);
            this.addChild(new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)new BasicStroke(2.0f), (Paint)Color.BLACK));
            this.addChild(new PText(string){
                {
                    super(string);
                    this.setFont(GENE_LABEL_FONT);
                    this.setOffset(doubleGeneralPath.getGeneralPath().getBounds2D().getCenterX() - this.getFullBoundsReference().width / 2.0, doubleGeneralPath.getGeneralPath().getBounds2D().getMaxY() + 5.0);
                }
            });
        }
    }
}

