/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneA;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.MotionBounds;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.GeneB;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.GeneC;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinA;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinB;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinC;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualGeneExpressionModel
extends GeneExpressionModel
implements Resettable {
    private final DnaMolecule dnaMolecule;
    public final ObservableList<MobileBiomolecule> mobileBiomoleculeList = new ObservableList();
    public final ObservableList<MessengerRna> messengerRnaList = new ObservableList();
    private final ConstantDtClock clock = new ConstantDtClock(30.0);
    public final Property<Gene> activeGene;
    public final ObservableProperty<Boolean> isFirstGeneActive;
    public final ObservableProperty<Boolean> isLastGeneActive;
    private final List<Shape> offLimitsMotionSpaces = new ArrayList<Shape>();
    public final Property<Integer> proteinACollected = new Property<Integer>(0);
    public final Property<Integer> proteinBCollected = new Property<Integer>(0);
    public final Property<Integer> proteinCCollected = new Property<Integer>(0);
    private final Map<Class<? extends Protein>, Property<Integer>> mapProteinClassToCollectedCount = new HashMap<Class<? extends Protein>, Property<Integer>>(){
        {
            this.put(ProteinA.class, ManualGeneExpressionModel.this.proteinACollected);
            this.put(ProteinB.class, ManualGeneExpressionModel.this.proteinBCollected);
            this.put(ProteinC.class, ManualGeneExpressionModel.this.proteinCCollected);
        }
    };
    private final Rectangle2D proteinCaptureArea = new Rectangle2D.Double();

    public ManualGeneExpressionModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                ManualGeneExpressionModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        this.dnaMolecule = new DnaMolecule(this, 2000, -17000.0, false);
        this.dnaMolecule.addGene(new GeneA(this.dnaMolecule, 442));
        this.dnaMolecule.addGene(new GeneB(this.dnaMolecule, 911));
        this.dnaMolecule.addGene(new GeneC(this.dnaMolecule, 1386));
        this.activeGene = new Property<Gene>(this.dnaMolecule.getGenes().get(0));
        this.isFirstGeneActive = this.activeGene.valueEquals(this.dnaMolecule.getGenes().get(0));
        this.isLastGeneActive = this.activeGene.valueEquals(this.dnaMolecule.getLastGene());
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    @Override
    public DnaMolecule getDnaMolecule() {
        return this.dnaMolecule;
    }

    public void previousGene() {
        this.switchToGeneRelative(-1);
    }

    public void nextGene() {
        this.switchToGeneRelative(1);
    }

    public void setProteinCaptureArea(Rectangle2D rectangle2D) {
        this.proteinCaptureArea.setFrame(rectangle2D);
    }

    public Property<Integer> getCollectedCounterForProteinType(Class<? extends Protein> clazz) {
        assert (this.mapProteinClassToCollectedCount.containsKey(clazz));
        return this.mapProteinClassToCollectedCount.get(clazz);
    }

    private void switchToGeneRelative(int n) {
        ArrayList<Gene> arrayList = this.dnaMolecule.getGenes();
        int n2 = MathUtil.clamp(0, arrayList.indexOf(this.activeGene.get()) + n, arrayList.size() - 1);
        this.activeGene.set(arrayList.get(n2));
    }

    private void activateGene(int n) {
        this.activeGene.set(this.dnaMolecule.getGenes().get(n));
    }

    @Override
    public void addMobileBiomolecule(final MobileBiomolecule mobileBiomolecule) {
        this.mobileBiomoleculeList.add(mobileBiomolecule);
        mobileBiomolecule.setMotionBounds(this.getBoundsForActiveGene());
        mobileBiomolecule.userControlled.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (bl.booleanValue()) {
                    ManualGeneExpressionModel.this.dnaMolecule.activateHints(mobileBiomolecule);
                    for (MessengerRna messengerRna : ManualGeneExpressionModel.this.messengerRnaList) {
                        messengerRna.activateHints(mobileBiomolecule);
                    }
                } else {
                    ManualGeneExpressionModel.this.dnaMolecule.deactivateAllHints();
                    for (MessengerRna messengerRna : ManualGeneExpressionModel.this.messengerRnaList) {
                        messengerRna.deactivateAllHints();
                    }
                    if (bl2.booleanValue() && ManualGeneExpressionModel.this.proteinCaptureArea.contains(mobileBiomolecule.getPosition().toPoint2D()) && mobileBiomolecule instanceof Protein) {
                        ManualGeneExpressionModel.this.captureProtein((Protein)mobileBiomolecule);
                    }
                }
            }
        });
        mobileBiomolecule.existenceStrength.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                if (d == 0.0) {
                    ManualGeneExpressionModel.this.removeMobileBiomolecule(mobileBiomolecule);
                    mobileBiomolecule.existenceStrength.removeObserver(this);
                }
            }
        });
    }

    @Override
    public List<MobileBiomolecule> getOverlappingBiomolecules(Shape shape) {
        ArrayList<MobileBiomolecule> arrayList = new ArrayList<MobileBiomolecule>();
        Rectangle2D rectangle2D = shape.getBounds2D();
        for (MobileBiomolecule mobileBiomolecule : this.mobileBiomoleculeList) {
            if (!mobileBiomolecule.getShape().getBounds2D().intersects(rectangle2D)) continue;
            Area area = new Area(shape);
            Area area2 = new Area(mobileBiomolecule.getShape());
            area2.intersect(area);
            if (area2.isEmpty()) continue;
            arrayList.add(mobileBiomolecule);
        }
        return arrayList;
    }

    private void captureProtein(Protein protein) {
        if (protein instanceof ProteinA) {
            this.proteinACollected.set(this.proteinACollected.get() + 1);
        }
        if (protein instanceof ProteinB) {
            this.proteinBCollected.set(this.proteinBCollected.get() + 1);
        }
        if (protein instanceof ProteinC) {
            this.proteinCCollected.set(this.proteinCCollected.get() + 1);
        }
        this.mobileBiomoleculeList.remove(protein);
    }

    public int getProteinCount(Class<? extends Protein> clazz) {
        int n = 0;
        for (MobileBiomolecule mobileBiomolecule : this.mobileBiomoleculeList) {
            if (mobileBiomolecule.getClass() != clazz) continue;
            ++n;
        }
        return n;
    }

    public void removeMobileBiomolecule(MobileBiomolecule mobileBiomolecule) {
        this.mobileBiomoleculeList.remove(mobileBiomolecule);
    }

    @Override
    public void addMessengerRna(MessengerRna messengerRna) {
        this.messengerRnaList.add(messengerRna);
        messengerRna.setMotionBounds(this.getBoundsForActiveGene());
    }

    @Override
    public void removeMessengerRna(MessengerRna messengerRna) {
        this.messengerRnaList.remove(messengerRna);
    }

    @Override
    public List<MessengerRna> getMessengerRnaList() {
        return this.messengerRnaList;
    }

    @Override
    public void reset() {
        this.mobileBiomoleculeList.clear();
        this.messengerRnaList.clear();
        this.dnaMolecule.reset();
        this.proteinACollected.reset();
        this.proteinBCollected.reset();
        this.proteinCCollected.reset();
        this.activateGene(0);
    }

    public void addOffLimitsMotionSpace(Shape shape) {
        for (Shape shape2 : this.offLimitsMotionSpaces) {
            if (!shape2.equals(shape)) continue;
            return;
        }
        this.offLimitsMotionSpaces.add(shape);
    }

    private void stepInTime(double d) {
        for (MobileBiomolecule mobileBiomolecule : new ArrayList<MobileBiomolecule>(this.mobileBiomoleculeList)) {
            mobileBiomolecule.stepInTime(d);
        }
        for (MessengerRna messengerRna : this.messengerRnaList) {
            messengerRna.stepInTime(d);
        }
        this.dnaMolecule.stepInTime(d);
    }

    public MotionBounds getBoundsForActiveGene() {
        double d = -2000.0;
        Area area = new Area(new Rectangle2D.Double(this.activeGene.get().getCenterX() - 5000.0, d, 10000.0, 6700.0));
        for (Shape shape : this.offLimitsMotionSpaces) {
            if (!area.intersects(shape.getBounds2D())) continue;
            area.subtract(new Area(shape));
        }
        return new MotionBounds(area);
    }
}

