/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

class BackgroundCellNode
extends PNode {
    public static final Dimension2D DEFAULT_SIZE = new PDimension(65000.0, 20000.0);
    private static final Color CELL_INTERIOR_COLOR = new Color(190, 231, 251);

    public BackgroundCellNode(Point2D point2D, int n) {
        this(point2D, DEFAULT_SIZE, 0.0, n);
    }

    public BackgroundCellNode(Point2D point2D, Dimension2D dimension2D, double d, int n) {
        PhetPPath phetPPath = new PhetPPath(BioShapeUtils.createEColiLikeShape(point2D, dimension2D.getWidth(), DEFAULT_SIZE.getHeight(), 0.0, n), (Stroke)new BasicStroke(500.0f), (Paint)Color.WHITE);
        phetPPath.rotateAboutPoint(d, point2D);
        GradientPaint gradientPaint = new GradientPaint((float)(point2D.getX() - dimension2D.getWidth() * 0.1), (float)(point2D.getY() - dimension2D.getHeight() * 0.5), ColorUtils.darkerColor(CELL_INTERIOR_COLOR, 0.25), (float)(point2D.getX() + dimension2D.getWidth() * 0.1), (float)(point2D.getY() + dimension2D.getHeight() * 0.5), ColorUtils.brighterColor(CELL_INTERIOR_COLOR, 0.25));
        phetPPath.setPaint(gradientPaint);
        this.addChild(phetPPath);
    }
}

