/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class FlashingShapeNode
extends PNode {
    private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);
    private final FlashController flashController;

    public FlashingShapeNode(Shape shape, Color color, int n, int n2, int n3, boolean bl, boolean bl2) {
        PhetPPath phetPPath = new PhetPPath(shape, (Paint)(bl ? color : INVISIBLE_COLOR));
        this.addChild(phetPPath);
        this.flashController = new FlashController(phetPPath, INVISIBLE_COLOR, color, n, n2, n3, bl, bl2);
    }

    public void startFlashing() {
        this.flashController.restart();
    }

    public void forceFlashOff() {
        this.flashController.forceFlashOff();
    }

    private static class FlashController {
        private int transitionCountdown = 0;
        private Timer flashTimer;
        private final PPath flashingNode;
        private final Color normalColor;
        private final Color flashColor;
        private final boolean flashOnAtStart;
        private final boolean flashOnAtEnd;
        private final int numFlashes;

        private FlashController(final PPath pPath, final Color color, final Color color2, final int n, final int n2, int n3, boolean bl, boolean bl2) {
            this.flashingNode = pPath;
            this.flashColor = color2;
            this.normalColor = color;
            this.flashOnAtStart = bl;
            this.flashOnAtEnd = bl2;
            this.numFlashes = n3;
            this.flashTimer = new Timer(Integer.MAX_VALUE, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n3;
                    if (pPath.getPaint() == color2) {
                        pPath.setPaint(color);
                        n3 = n2;
                    } else {
                        pPath.setPaint(color2);
                        n3 = n;
                    }
                    FlashController.this.transitionCountdown--;
                    if (FlashController.this.transitionCountdown > 0) {
                        FlashController.this.flashTimer.setInitialDelay(n3);
                        FlashController.this.flashTimer.restart();
                    } else {
                        FlashController.this.flashTimer.stop();
                    }
                }
            });
            this.flashTimer.setRepeats(false);
        }

        public void restart() {
            this.flashTimer.stop();
            this.setFlashOn(this.flashOnAtStart);
            this.transitionCountdown = this.numFlashes * 2;
            if (this.flashOnAtStart != this.flashOnAtEnd) {
                --this.transitionCountdown;
            }
            this.flashTimer.setInitialDelay(0);
            this.flashTimer.restart();
        }

        public boolean isFlashing() {
            return this.flashTimer.isRunning();
        }

        public void stop() {
            this.flashTimer.stop();
        }

        public void forceFlashOff() {
            if (this.isFlashing()) {
                this.stop();
            }
            this.setFlashOn(false);
        }

        private void setFlashOn(boolean bl) {
            this.flashingNode.setPaint(bl ? this.flashColor : this.normalColor);
        }
    }
}

