/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.PlacementHint;
import edu.colorado.phet.geneexpressionbasics.common.view.DnaMoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MessengerRnaNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.PlacementHintNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ManualGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.BackgroundCellNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.BiomoleculeToolBoxNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.ProteinCollectionNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualGeneExpressionCanvas
extends PhetPCanvas
implements Resettable {
    private static final Dimension2D STAGE_SIZE = new PDimension(1008.0, 679.0);
    private final ModelViewTransform mvt;
    private final MutableVector2D viewportOffset = new MutableVector2D(0.0, 0.0);
    private final List<BiomoleculeToolBoxNode> biomoleculeToolBoxNodeList = new ArrayList<BiomoleculeToolBoxNode>();
    private final PNode backgroundCellLayer;
    private final PNode modelRootNode;
    private final BackgroundCellNode backgroundCell;
    private Property<Double> zoomedInProportion = new Property<Double>(1.0);

    public ManualGeneExpressionCanvas(final ManualGeneExpressionModel manualGeneExpressionModel) {
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(STAGE_SIZE.getWidth() * 0.5), (int)Math.round(STAGE_SIZE.getHeight() * 0.7)), 0.1);
        this.setBackground(Color.BLACK);
        this.backgroundCellLayer = new PNode();
        this.addWorldChild(this.backgroundCellLayer);
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        this.modelRootNode = new PNode();
        this.addWorldChild(this.modelRootNode);
        PNode pNode2 = new PNode();
        this.modelRootNode.addChild(pNode2);
        final PNode pNode3 = new PNode();
        this.modelRootNode.addChild(pNode3);
        final PNode pNode4 = new PNode();
        this.modelRootNode.addChild(pNode4);
        final PNode pNode5 = new PNode();
        this.modelRootNode.addChild(pNode5);
        PNode pNode6 = new PNode();
        this.modelRootNode.addChild(pNode6);
        PNode pNode7 = new PNode();
        this.addWorldChild(pNode7);
        this.backgroundCell = new BackgroundCellNode(this.mvt.modelToView(manualGeneExpressionModel.getDnaMolecule().getLeftEdgePos().getX() + manualGeneExpressionModel.getDnaMolecule().getLength() / 2.0, 0.0), 6);
        this.backgroundCell.setPickable(true);
        this.backgroundCell.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                if (ManualGeneExpressionCanvas.this.isZoomedOut()) {
                    ManualGeneExpressionCanvas.this.zoomIn(2000L);
                }
            }
        });
        this.backgroundCellLayer.addChild(this.backgroundCell);
        this.backgroundCellLayer.addChild(new BackgroundCellNode(new Point2D.Double(40000.0, -40000.0), 2));
        this.backgroundCellLayer.addChild(new BackgroundCellNode(new Point2D.Double(-40000.0, -60000.0), new PDimension(BackgroundCellNode.DEFAULT_SIZE.getWidth() * 0.7, BackgroundCellNode.DEFAULT_SIZE.getHeight()), -0.5235987755982988, 2));
        this.backgroundCellLayer.addChild(new BackgroundCellNode(new Point2D.Double(-1000.0, -85000.0), new PDimension(BackgroundCellNode.DEFAULT_SIZE.getWidth() * 0.7, BackgroundCellNode.DEFAULT_SIZE.getHeight()), -0.5235987755982988, 2));
        this.backgroundCellLayer.addChild(new BackgroundCellNode(new Point2D.Double(90000.0, -60000.0), new PDimension(BackgroundCellNode.DEFAULT_SIZE.getWidth() * 0.8, BackgroundCellNode.DEFAULT_SIZE.getHeight()), 0.39269908169872414, 2));
        this.backgroundCellLayer.addChild(new BackgroundCellNode(new Point2D.Double(-100000.0, -20000.0), new PDimension(BackgroundCellNode.DEFAULT_SIZE.getWidth() * 0.8, BackgroundCellNode.DEFAULT_SIZE.getHeight()), 0.15707963267948966, 2));
        final DnaMoleculeNode dnaMoleculeNode = new DnaMoleculeNode(manualGeneExpressionModel.getDnaMolecule(), this.mvt, 3.0f, true);
        pNode2.addChild(dnaMoleculeNode);
        for (Gene object32 : manualGeneExpressionModel.getDnaMolecule().getGenes()) {
            for (PlacementHint placementHint : object32.getPlacementHints()) {
                pNode6.addChild(new PlacementHintNode(this.mvt, placementHint));
            }
        }
        final ProteinCollectionNode proteinCollectionNode = new ProteinCollectionNode(manualGeneExpressionModel, this.mvt){
            {
                this.setOffset(STAGE_SIZE.getWidth() - this.getFullBoundsReference().width - 15.0, 15.0);
            }
        };
        pNode.addChild(proteinCollectionNode);
        for (MobileBiomolecule mobileBiomolecule : manualGeneExpressionModel.mobileBiomoleculeList) {
            pNode5.addChild(new MobileBiomoleculeNode(this.mvt, mobileBiomolecule));
        }
        manualGeneExpressionModel.mobileBiomoleculeList.addElementAddedObserver(new VoidFunction1<MobileBiomolecule>(){

            @Override
            public void apply(final MobileBiomolecule mobileBiomolecule) {
                final MobileBiomoleculeNode mobileBiomoleculeNode = new MobileBiomoleculeNode(ManualGeneExpressionCanvas.this.mvt, mobileBiomolecule);
                pNode5.addChild(mobileBiomoleculeNode);
                manualGeneExpressionModel.mobileBiomoleculeList.addElementRemovedObserver(new VoidFunction1<MobileBiomolecule>(){

                    @Override
                    public void apply(MobileBiomolecule mobileBiomolecule2) {
                        if (mobileBiomolecule2 == mobileBiomolecule) {
                            pNode5.removeChild(mobileBiomoleculeNode);
                        }
                    }
                });
            }
        });
        manualGeneExpressionModel.messengerRnaList.addElementAddedObserver(new VoidFunction1<MessengerRna>(){

            @Override
            public void apply(final MessengerRna messengerRna) {
                final MessengerRnaNode messengerRnaNode = new MessengerRnaNode(ManualGeneExpressionCanvas.this.mvt, messengerRna);
                pNode4.addChild(messengerRnaNode);
                manualGeneExpressionModel.messengerRnaList.addElementRemovedObserver(new VoidFunction1<MessengerRna>(){

                    @Override
                    public void apply(MessengerRna messengerRna2) {
                        if (messengerRna2 == messengerRna) {
                            pNode4.removeChild(messengerRnaNode);
                        }
                    }
                });
            }
        });
        final HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(GeneExpressionBasicsResources.Strings.NEXT_GENE, GeneExpressionBasicsResources.Images.GRAY_ARROW){
            {
                super(string, bufferedImage);
                this.setTextPosition(HTMLImageButtonNode.TextPosition.LEFT);
                this.setFont(new PhetFont(20));
                this.setOffset(STAGE_SIZE.getWidth() - this.getFullBoundsReference().width - 20.0, ManualGeneExpressionCanvas.this.mvt.modelToViewY(manualGeneExpressionModel.getDnaMolecule().getLeftEdgePos().getY()) + 90.0);
                this.setBackground(Color.GREEN);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        manualGeneExpressionModel.nextGene();
                    }
                });
                manualGeneExpressionModel.isLastGeneActive.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setEnabled(bl == false);
                    }
                });
            }
        };
        pNode7.addChild(hTMLImageButtonNode);
        final HTMLImageButtonNode hTMLImageButtonNode2 = new HTMLImageButtonNode(GeneExpressionBasicsResources.Strings.PREVIOUS_GENE, BufferedImageUtils.flipX(GeneExpressionBasicsResources.Images.GRAY_ARROW)){
            {
                super(string, bufferedImage);
                this.setTextPosition(HTMLImageButtonNode.TextPosition.RIGHT);
                this.setFont(new PhetFont(20));
                this.setOffset(20.0, ManualGeneExpressionCanvas.this.mvt.modelToViewY(manualGeneExpressionModel.getDnaMolecule().getLeftEdgePos().getY()) + 90.0);
                this.setBackground(Color.GREEN);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        manualGeneExpressionModel.previousGene();
                    }
                });
                manualGeneExpressionModel.isFirstGeneActive.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setEnabled(bl == false);
                    }
                });
            }
        };
        pNode7.addChild(hTMLImageButtonNode2);
        final ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{manualGeneExpressionModel, this}, this, 18, Color.BLACK, new Color(255, 153, 0)){
            {
                super(resettableArray, component, n, color, color2);
                this.setConfirmationEnabled(false);
                this.centerFullBoundsOnPoint(hTMLImageButtonNode.getFullBoundsReference().getCenterX(), hTMLImageButtonNode.getFullBoundsReference().getMaxY() + 40.0);
            }
        };
        pNode7.addChild(resetAllButtonNode);
        manualGeneExpressionModel.activeGene.addObserver(new VoidFunction1<Gene>(){

            @Override
            public void apply(Gene gene) {
                ManualGeneExpressionCanvas.this.terminateActivitiesWithoutFinishing();
                ManualGeneExpressionCanvas.this.viewportOffset.setComponents(-ManualGeneExpressionCanvas.this.mvt.modelToViewX(gene.getCenterX()) + STAGE_SIZE.getWidth() / 2.0, 0.0);
                ManualGeneExpressionCanvas.this.backgroundCellLayer.animateToPositionScaleRotation(ManualGeneExpressionCanvas.this.viewportOffset.getX(), ManualGeneExpressionCanvas.this.viewportOffset.getY(), 1.0, 0.0, 1000L);
                PTransformActivity pTransformActivity = ManualGeneExpressionCanvas.this.modelRootNode.animateToPositionScaleRotation(ManualGeneExpressionCanvas.this.viewportOffset.getX(), ManualGeneExpressionCanvas.this.viewportOffset.getY(), 1.0, 0.0, 1000L);
                pTransformActivity.setDelegate(new PActivityDelegateAdapter(){

                    public void activityFinished(PActivity pActivity) {
                        Rectangle2D rectangle2D;
                        PBounds pBounds = proteinCollectionNode.getFullBounds();
                        try {
                            rectangle2D = ManualGeneExpressionCanvas.this.modelRootNode.getTransformReference(true).createInverse().createTransformedShape(pBounds).getBounds2D();
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            System.out.println(this.getClass().getName() + " - Error: Unable to invert transform needed to update the protein capture area.");
                            noninvertibleTransformException.printStackTrace();
                            rectangle2D = new PBounds();
                        }
                        Rectangle2D rectangle2D2 = ManualGeneExpressionCanvas.this.mvt.viewToModel(rectangle2D).getBounds2D();
                        manualGeneExpressionModel.setProteinCaptureArea(rectangle2D2);
                        manualGeneExpressionModel.addOffLimitsMotionSpace(rectangle2D2);
                    }
                });
            }
        });
        for (final Gene gene : manualGeneExpressionModel.getDnaMolecule().getGenes()) {
            BiomoleculeToolBoxNode biomoleculeToolBoxNode = new BiomoleculeToolBoxNode(manualGeneExpressionModel, this, this.mvt, gene){
                {
                    super(manualGeneExpressionModel, manualGeneExpressionCanvas2, modelViewTransform, gene3);
                    this.setOffset(this.mvt.modelToViewX(gene.getCenterX()) - STAGE_SIZE.getWidth() / 2.0 + 15.0, 15.0);
                }
            };
            this.biomoleculeToolBoxNodeList.add(biomoleculeToolBoxNode);
            pNode3.addChild(biomoleculeToolBoxNode);
            manualGeneExpressionModel.addOffLimitsMotionSpace(this.mvt.viewToModel(biomoleculeToolBoxNode.getFullBoundsReference()));
        }
        final TextButtonNode textButtonNode = new TextButtonNode(GeneExpressionBasicsResources.Strings.ZOOM_IN, new PhetFont(18), Color.YELLOW){
            {
                super(string, font, color);
                this.centerFullBoundsOnPoint(hTMLImageButtonNode2.getFullBoundsReference().getCenterX(), hTMLImageButtonNode2.getFullBoundsReference().getMaxY() + 40.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ManualGeneExpressionCanvas.this.zoomIn(2000L);
                    }
                });
            }
        };
        pNode7.addChild(textButtonNode);
        this.zoomedInProportion.addObserver(new VoidFunction1<Double>(){
            private final CursorHandler handCursor = new CursorHandler(CursorHandler.HAND);
            private final CursorHandler defaultCursor = new CursorHandler(CursorHandler.DEFAULT);

            @Override
            public void apply(Double d) {
                pNode3.setVisible(ManualGeneExpressionCanvas.this.isZoomedIn());
                proteinCollectionNode.setVisible(ManualGeneExpressionCanvas.this.isZoomedIn());
                hTMLImageButtonNode2.setVisible(ManualGeneExpressionCanvas.this.isZoomedIn());
                hTMLImageButtonNode.setVisible(ManualGeneExpressionCanvas.this.isZoomedIn());
                resetAllButtonNode.setVisible(ManualGeneExpressionCanvas.this.isZoomedIn());
                textButtonNode.setVisible(ManualGeneExpressionCanvas.this.isZoomedOut());
                float f = (float)Math.pow(d, 2.0);
                if ((double)f < 0.001) {
                    f = 0.0f;
                }
                dnaMoleculeNode.setTransparency(f);
                if (ManualGeneExpressionCanvas.this.isZoomedOut()) {
                    if (ManualGeneExpressionCanvas.this.arrayContainsItem(ManualGeneExpressionCanvas.this.backgroundCell.getInputEventListeners(), this.defaultCursor)) {
                        ManualGeneExpressionCanvas.this.backgroundCell.removeInputEventListener(this.defaultCursor);
                    }
                    if (!ManualGeneExpressionCanvas.this.arrayContainsItem(ManualGeneExpressionCanvas.this.backgroundCell.getInputEventListeners(), this.handCursor)) {
                        ManualGeneExpressionCanvas.this.backgroundCell.addInputEventListener(this.handCursor);
                    }
                } else if (ManualGeneExpressionCanvas.this.arrayContainsItem(ManualGeneExpressionCanvas.this.backgroundCell.getInputEventListeners(), this.handCursor)) {
                    ManualGeneExpressionCanvas.this.backgroundCell.removeInputEventListener(this.handCursor);
                    if (!ManualGeneExpressionCanvas.this.arrayContainsItem(ManualGeneExpressionCanvas.this.backgroundCell.getInputEventListeners(), this.defaultCursor)) {
                        ManualGeneExpressionCanvas.this.backgroundCell.addInputEventListener(this.defaultCursor);
                    }
                }
            }
        });
    }

    public void zoomIn(long l) {
        this.zoomInOnNodes(l, this.backgroundCellLayer, this.modelRootNode);
    }

    public void zoomOut(long l) {
        this.zoomOutFromNodes(l, this.backgroundCellLayer, this.modelRootNode);
    }

    private void zoomInOnNodes(long l, PNode ... pNodeArray) {
        this.terminateAndFinishRunningActivities();
        PActivity pActivity = null;
        for (PNode pNode : pNodeArray) {
            pActivity = pNode.animateToPositionScaleRotation(this.viewportOffset.getX(), this.viewportOffset.getY(), 1.0, 0.0, l);
        }
        if (pActivity != null) {
            pActivity.setDelegate(new PActivityDelegateAdapter(){

                public void activityFinished(PActivity pActivity) {
                    ManualGeneExpressionCanvas.this.zoomedInProportion.set(1.0);
                    pActivity.setDelegate(null);
                }

                public void activityStepped(PActivity pActivity) {
                    ManualGeneExpressionCanvas.this.zoomedInProportion.set((double)(pActivity.getNextStepTime() - pActivity.getStartTime()) / (double)pActivity.getDuration());
                }
            });
        }
    }

    private void zoomOutFromNodes(long l, PNode ... pNodeArray) {
        this.terminateAndFinishRunningActivities();
        PActivity pActivity = null;
        for (PNode pNode : pNodeArray) {
            pActivity = pNode.animateToPositionScaleRotation(STAGE_SIZE.getWidth() / 2.0, this.mvt.modelToViewY(0.0), 0.005, 0.0, l);
        }
        if (pActivity != null) {
            pActivity.setDelegate(new PActivityDelegateAdapter(){

                public void activityFinished(PActivity pActivity) {
                    ManualGeneExpressionCanvas.this.zoomedInProportion.set(0.0);
                    pActivity.setDelegate(null);
                }

                public void activityStepped(PActivity pActivity) {
                    ManualGeneExpressionCanvas.this.zoomedInProportion.set(1.0 - (double)(pActivity.getNextStepTime() - pActivity.getStartTime()) / (double)pActivity.getDuration());
                }
            });
        }
    }

    private void terminateAndFinishRunningActivities() {
        for (Object e : new ArrayList(this.getRoot().getActivityScheduler().getActivitiesReference())) {
            ((PActivity)e).terminate(1);
        }
    }

    private void terminateActivitiesWithoutFinishing() {
        for (Object e : new ArrayList(this.getRoot().getActivityScheduler().getActivitiesReference())) {
            ((PActivity)e).terminate(0);
        }
    }

    private boolean arrayContainsItem(Object[] objectArray, Object object) {
        boolean bl = false;
        for (Object object2 : objectArray) {
            if (object != object2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isZoomedOut() {
        return this.zoomedInProportion.get() == 0.0;
    }

    private boolean isZoomedIn() {
        return this.zoomedInProportion.get() == 1.0;
    }

    public Vector2D getViewportOffset() {
        return new Vector2D(this.viewportOffset);
    }

    public ObservableProperty<Double> getZoomedInProperty() {
        return this.zoomedInProportion;
    }

    @Override
    public void reset() {
        for (BiomoleculeToolBoxNode biomoleculeToolBoxNode : this.biomoleculeToolBoxNodeList) {
            biomoleculeToolBoxNode.reset();
        }
        if (!this.isZoomedIn()) {
            this.zoomIn(0L);
        }
    }

    private static class PActivityDelegateAdapter
    implements PActivity.PActivityDelegate {
        private PActivityDelegateAdapter() {
        }

        public void activityStarted(PActivity pActivity) {
        }

        public void activityStepped(PActivity pActivity) {
        }

        public void activityFinished(PActivity pActivity) {
        }
    }
}

