/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ManualGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinA;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinB;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ProteinC;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.FlashingShapeNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

class ProteinCollectionNode
extends PNode {
    private static final Font TITLE_FONT = new PhetFont(20, true);
    private static final Font READOUT_FONT = new PhetFont(18);
    private static final Color BACKGROUND_COLOR = new Color(255, 250, 205);

    public ProteinCollectionNode(ManualGeneExpressionModel manualGeneExpressionModel, ModelViewTransform modelViewTransform) {
        HTMLNode hTMLNode = new HTMLNode(GeneExpressionBasicsResources.Strings.YOUR_PROTEIN_COLLECTION, Color.BLACK, TITLE_FONT){
            {
                if (this.getFullBoundsReference().getWidth() > 300.0) {
                    this.setScale(300.0 / this.getFullBoundsReference().width);
                }
            }
        };
        ProteinCollectionArea proteinCollectionArea = new ProteinCollectionArea(manualGeneExpressionModel, modelViewTransform);
        assert (proteinCollectionArea.getFullBoundsReference().width <= 300.0);
        VBox vBox = new VBox(hTMLNode, proteinCollectionArea, new CollectionCountIndicator(manualGeneExpressionModel));
        this.addChild(new ControlPanelNode((PNode)vBox, BACKGROUND_COLOR));
    }

    private static class CollectionCountIndicator
    extends PNode {
        final PNode collectionCompleteNode = new PText(GeneExpressionBasicsResources.Strings.COLLECTION_COMPLETE){
            {
                this.setFont(new PhetFont(20));
                if (this.getFullBoundsReference().width > 300.0) {
                    this.setScale(300.0 / this.getFullBoundsReference().width);
                }
            }
        };

        public CollectionCountIndicator(final ManualGeneExpressionModel manualGeneExpressionModel) {
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    CollectionCountIndicator.this.updateCount(manualGeneExpressionModel);
                }
            };
            manualGeneExpressionModel.proteinACollected.addObserver(simpleObserver);
            manualGeneExpressionModel.proteinBCollected.addObserver(simpleObserver);
            manualGeneExpressionModel.proteinCCollected.addObserver(simpleObserver);
        }

        private void updateCount(ManualGeneExpressionModel manualGeneExpressionModel) {
            int n = 0;
            if (manualGeneExpressionModel.proteinACollected.get() > 0) {
                ++n;
            }
            if (manualGeneExpressionModel.proteinBCollected.get() > 0) {
                ++n;
            }
            if (manualGeneExpressionModel.proteinCCollected.get() > 0) {
                ++n;
            }
            this.removeAllChildren();
            VBox vBox = new VBox(5.0, new HBox(4.0, new ReadoutPText(GeneExpressionBasicsResources.Strings.PROTEIN_COUNT_CAPTION_PART_1), new IntegerBox(n)), new ReadoutPText(GeneExpressionBasicsResources.Strings.PROTEIN_COUNT_CAPTION_PART_2){
                {
                    this.setFont(READOUT_FONT);
                }
            });
            if (vBox.getFullBoundsReference().width > 300.0) {
                vBox.setScale(300.0 / this.getFullBoundsReference().width);
            }
            this.collectionCompleteNode.centerFullBoundsOnPoint(vBox.getFullBoundsReference().getCenterX(), vBox.getFullBoundsReference().getCenterY());
            this.addChild(vBox);
            this.addChild(this.collectionCompleteNode);
            ((PNode)vBox).setVisible((double)n != 3.0);
            this.collectionCompleteNode.setVisible((double)n == 3.0);
        }
    }

    private static class IntegerBox
    extends PNode {
        private static final Color BACKGROUND_COLOR = new Color(240, 240, 240);

        private IntegerBox(int n) {
            ReadoutPText readoutPText = new ReadoutPText(Integer.toString(n));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, readoutPText.getFullBoundsReference().width * 2.0, readoutPText.getFullBoundsReference().height);
            PhetPPath phetPPath = new PhetPPath(double_, BACKGROUND_COLOR, new BasicStroke(1.0f), Color.BLACK);
            this.addChild(phetPPath);
            readoutPText.centerFullBoundsOnPoint(phetPPath.getFullBoundsReference().getCenterX(), phetPPath.getFullBoundsReference().getCenterY());
            this.addChild(readoutPText);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProteinCaptureNode
    extends PNode {
        private static final Color FLASH_COLOR = new Color(173, 255, 47);

        private ProteinCaptureNode(final ManualGeneExpressionModel manualGeneExpressionModel, final Class<? extends Protein> clazz, AffineTransform affineTransform, Dimension2D dimension2D) {
            Object object;
            Shape shape = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
            Color color = Color.PINK;
            try {
                object = clazz.newInstance();
                shape = affineTransform.createTransformedShape(((Protein)object).getFullyGrownShape());
                color = (Color)((Protein)object).colorProperty.get();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight()), (Paint)new Color(0, 0, 0, 0)));
            object = AffineTransform.getScaleInstance(1.5, 1.5).createTransformedShape(shape);
            final FlashingShapeNode flashingShapeNode = new FlashingShapeNode((Shape)object, FLASH_COLOR, 350, 350, 4, false, true);
            this.addChild(flashingShapeNode);
            final PPath pPath = new PPath(shape);
            this.addChild(pPath);
            final Paint paint = MobileBiomoleculeNode.createGradientPaint(shape, color);
            final PText pText = new PText(){
                {
                    this.setFont(new PhetFont(18));
                }
            };
            this.addChild(pText);
            manualGeneExpressionModel.getCollectedCounterForProteinType(clazz).addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    pText.setText(Integer.toString(n));
                    pText.setOffset(pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().width / 2.0, pPath.getFullBoundsReference().getCenterY() + 35.0);
                }
            });
            manualGeneExpressionModel.mobileBiomoleculeList.addElementAddedObserver(new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    if (mobileBiomolecule.getClass() == clazz) {
                        Protein protein = (Protein)mobileBiomolecule;
                        protein.fullGrown.addObserver(new ChangeObserver<Boolean>(){

                            @Override
                            public void update(Boolean bl, Boolean bl2) {
                                if (bl.booleanValue() && !bl2.booleanValue()) {
                                    flashingShapeNode.startFlashing();
                                }
                            }
                        });
                    }
                }
            });
            Property<Integer> property = manualGeneExpressionModel.getCollectedCounterForProteinType(clazz);
            property.addObserver(new VoidFunction1<Integer>(){

                @Override
                public void apply(Integer n) {
                    if (n > 0) {
                        pPath.setPaint(paint);
                    } else {
                        pPath.setPaint(Color.BLACK);
                    }
                }
            });
            manualGeneExpressionModel.mobileBiomoleculeList.addElementRemovedObserver(new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    if (mobileBiomolecule.getClass() == clazz && manualGeneExpressionModel.getProteinCount(clazz) == 0) {
                        flashingShapeNode.forceFlashOff();
                    }
                }
            });
        }
    }

    private static class ProteinCollectionArea
    extends PNode {
        private ProteinCollectionArea(ManualGeneExpressionModel manualGeneExpressionModel, ModelViewTransform modelViewTransform) {
            double d = modelViewTransform.getTransform().getScaleX();
            assert (d == -modelViewTransform.getTransform().getScaleY());
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, -d);
            PDimension pDimension = new PDimension(0.0, 0.0);
            for (Class clazz : Arrays.asList(ProteinA.class, ProteinB.class, ProteinC.class)) {
                try {
                    Protein protein = (Protein)clazz.newInstance();
                    Rectangle2D rectangle2D = affineTransform.createTransformedShape(protein.getFullyGrownShape()).getBounds2D();
                    ((Dimension2D)pDimension).setSize(Math.max(rectangle2D.getWidth() * 1.5, ((Dimension2D)pDimension).getWidth()), Math.max(rectangle2D.getHeight() * 1.5, ((Dimension2D)pDimension).getHeight()));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Exception thrown when instantiating protein, e = " + exception);
                }
            }
            this.addChild(new HBox(0.0, new ProteinCaptureNode(manualGeneExpressionModel, ProteinA.class, affineTransform, pDimension), new ProteinCaptureNode(manualGeneExpressionModel, ProteinB.class, affineTransform, pDimension), new ProteinCaptureNode(manualGeneExpressionModel, ProteinC.class, affineTransform, pDimension)));
        }
    }

    private static class ReadoutPText
    extends PText {
        private ReadoutPText(String string) {
            super(string);
            this.setFont(READOUT_FONT);
        }
    }
}

