/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.mrnaproduction.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsSimSharing;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.PlacementHint;
import edu.colorado.phet.geneexpressionbasics.common.view.DnaMoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MessengerRnaNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.PlacementHintNode;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.model.MessengerRnaProductionModel;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.view.PolymeraseAffinityControlPanel;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.view.TranscriptionFactorControlPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class MessengerRnaProductionCanvas
extends PhetPCanvas
implements Resettable {
    private static final Dimension2D STAGE_SIZE = new PDimension(1008.0, 679.0);
    private final ModelViewTransform mvt;
    private final BooleanProperty clockRunning = new BooleanProperty(false);
    private final BooleanProperty negativeTranscriptionFactorEnabled = new BooleanProperty(false);

    public MessengerRnaProductionCanvas(final MessengerRnaProductionModel messengerRnaProductionModel) {
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(STAGE_SIZE.getWidth() * 0.5), (int)Math.round(STAGE_SIZE.getHeight() * 0.4)), 0.2);
        this.setBackground(new Color(171, 202, 217));
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        final PNode pNode2 = new PNode();
        pNode.addChild(pNode2);
        PNode pNode3 = new PNode();
        pNode.addChild(pNode3);
        final PNode pNode4 = new PNode();
        pNode.addChild(pNode4);
        final PNode pNode5 = new PNode();
        pNode.addChild(pNode5);
        PNode pNode6 = new PNode();
        pNode.addChild(pNode6);
        PNode pNode7 = new PNode();
        this.addWorldChild(pNode7);
        DnaMoleculeNode dnaMoleculeNode = new DnaMoleculeNode(messengerRnaProductionModel.getDnaMolecule(), this.mvt, 5.0f, false);
        pNode2.addChild(dnaMoleculeNode);
        for (Gene object22 : messengerRnaProductionModel.getDnaMolecule().getGenes()) {
            for (PlacementHint placementHint : object22.getPlacementHints()) {
                pNode6.addChild(new PlacementHintNode(this.mvt, placementHint));
            }
        }
        Gene gene = messengerRnaProductionModel.getDnaMolecule().getGenes().get(0);
        TranscriptionFactorControlPanel transcriptionFactorControlPanel = new TranscriptionFactorControlPanel(messengerRnaProductionModel, MessengerRnaProductionModel.POSITIVE_TRANSCRIPTION_FACTOR_CONFIG, gene.getTranscriptionFactorAffinityProperty(MessengerRnaProductionModel.POSITIVE_TRANSCRIPTION_FACTOR_CONFIG));
        pNode7.addChild(transcriptionFactorControlPanel);
        PolymeraseAffinityControlPanel polymeraseAffinityControlPanel = new PolymeraseAffinityControlPanel(MessengerRnaProductionModel.POSITIVE_TRANSCRIPTION_FACTOR_CONFIG, transcriptionFactorControlPanel.getFullBoundsReference().height, gene.getPolymeraseAffinityProperty());
        pNode7.addChild(polymeraseAffinityControlPanel);
        final TranscriptionFactorControlPanel transcriptionFactorControlPanel2 = new TranscriptionFactorControlPanel(messengerRnaProductionModel, MessengerRnaProductionModel.NEGATIVE_TRANSCRIPTION_FACTOR_CONFIG, gene.getTranscriptionFactorAffinityProperty(MessengerRnaProductionModel.NEGATIVE_TRANSCRIPTION_FACTOR_CONFIG));
        pNode7.addChild(transcriptionFactorControlPanel2);
        PropertyCheckBoxNode propertyCheckBoxNode = new PropertyCheckBoxNode(GeneExpressionBasicsSimSharing.UserComponents.negativeTranscriptionFactorCheckBox, GeneExpressionBasicsResources.Strings.NEGATIVE_TRANSCRIPTION_FACTOR, this.negativeTranscriptionFactorEnabled);
        pNode7.addChild(propertyCheckBoxNode);
        this.negativeTranscriptionFactorEnabled.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                transcriptionFactorControlPanel2.setVisible(bl);
                if (!bl.booleanValue()) {
                    messengerRnaProductionModel.negativeTranscriptionFactorCount.reset();
                }
            }
        });
        final ConstantDtClock constantDtClock = messengerRnaProductionModel.getClock();
        this.clockRunning.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                constantDtClock.setRunning(bl);
            }
        });
        FloatingClockControlNode floatingClockControlNode = new FloatingClockControlNode(this.clockRunning, null, messengerRnaProductionModel.getClock(), null, new Property<Color>(Color.white));
        pNode7.addChild(floatingClockControlNode);
        messengerRnaProductionModel.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                MessengerRnaProductionCanvas.this.clockRunning.set(true);
            }
        });
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{messengerRnaProductionModel, this}, this, 18, Color.BLACK, new Color(255, 153, 0)){
            {
                this.setConfirmationEnabled(false);
            }
        };
        pNode7.addChild(resetAllButtonNode);
        transcriptionFactorControlPanel.setOffset(15.0, STAGE_SIZE.getHeight() - transcriptionFactorControlPanel.getFullBoundsReference().height - 15.0);
        polymeraseAffinityControlPanel.setOffset(transcriptionFactorControlPanel.getFullBoundsReference().getMaxX() + 10.0, transcriptionFactorControlPanel.getFullBoundsReference().getMinY());
        transcriptionFactorControlPanel2.setOffset(polymeraseAffinityControlPanel.getFullBoundsReference().getMaxX() + 10.0, polymeraseAffinityControlPanel.getFullBoundsReference().getMinY());
        double d = (transcriptionFactorControlPanel2.getFullBoundsReference().getMaxX() + STAGE_SIZE.getWidth()) / 2.0;
        resetAllButtonNode.setOffset(d - resetAllButtonNode.getFullBoundsReference().width / 2.0, transcriptionFactorControlPanel.getFullBoundsReference().getMaxY() - resetAllButtonNode.getFullBoundsReference().height);
        propertyCheckBoxNode.setOffset(d - propertyCheckBoxNode.getFullBoundsReference().width / 2.0, resetAllButtonNode.getFullBoundsReference().getMinY() - propertyCheckBoxNode.getFullBoundsReference().height - 10.0);
        floatingClockControlNode.setOffset(d - floatingClockControlNode.getFullBoundsReference().width / 2.0, propertyCheckBoxNode.getFullBoundsReference().getMinY() - floatingClockControlNode.getFullBoundsReference().height - 10.0);
        messengerRnaProductionModel.mobileBiomoleculeList.addElementAddedObserver(new VoidFunction1<MobileBiomolecule>(){

            @Override
            public void apply(final MobileBiomolecule mobileBiomolecule) {
                final MobileBiomoleculeNode mobileBiomoleculeNode = new MobileBiomoleculeNode(MessengerRnaProductionCanvas.this.mvt, mobileBiomolecule);
                mobileBiomoleculeNode.setPickable(false);
                mobileBiomoleculeNode.setChildrenPickable(false);
                mobileBiomolecule.attachedToDna.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            pNode5.removeChild(mobileBiomoleculeNode);
                            pNode2.addChild(mobileBiomoleculeNode);
                        } else {
                            pNode2.removeChild(mobileBiomoleculeNode);
                            pNode5.addChild(mobileBiomoleculeNode);
                        }
                    }
                });
                messengerRnaProductionModel.mobileBiomoleculeList.addElementRemovedObserver(new VoidFunction1<MobileBiomolecule>(){

                    @Override
                    public void apply(MobileBiomolecule mobileBiomolecule2) {
                        if (mobileBiomolecule2 == mobileBiomolecule) {
                            if (pNode5.isAncestorOf(mobileBiomoleculeNode)) {
                                pNode5.removeChild(mobileBiomoleculeNode);
                            } else if (pNode2.isAncestorOf(mobileBiomoleculeNode)) {
                                pNode2.removeChild(mobileBiomoleculeNode);
                            }
                        }
                    }
                });
            }
        });
        messengerRnaProductionModel.messengerRnaList.addElementAddedObserver(new VoidFunction1<MessengerRna>(){

            @Override
            public void apply(final MessengerRna messengerRna) {
                final MessengerRnaNode messengerRnaNode = new MessengerRnaNode(MessengerRnaProductionCanvas.this.mvt, messengerRna);
                pNode4.addChild(messengerRnaNode);
                messengerRnaProductionModel.messengerRnaList.addElementRemovedObserver(new VoidFunction1<MessengerRna>(){

                    @Override
                    public void apply(MessengerRna messengerRna2) {
                        if (messengerRna2 == messengerRna) {
                            pNode4.removeChild(messengerRnaNode);
                        }
                    }
                });
            }
        });
    }

    public void reset() {
        this.clockRunning.set(true);
        this.negativeTranscriptionFactorEnabled.reset();
    }

    private static class PropertyCheckBoxNode
    extends PNode {
        private PropertyCheckBoxNode(IUserComponent iUserComponent, String string, BooleanProperty booleanProperty) {
            PropertyCheckBox propertyCheckBox = new PropertyCheckBox(iUserComponent, string, booleanProperty);
            propertyCheckBox.setFont(new PhetFont(18));
            propertyCheckBox.setBackground(new Color(0, 0, 0, 0));
            this.addChild(new PSwing(propertyCheckBox));
        }
    }
}

