/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.model;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.util.Random;

public class CellProteinSynthesisSimulator {
    public static final IntegerRange TRANSCRIPTION_FACTOR_COUNT_RANGE = new IntegerRange(200, 20000);
    public static final DoubleRange TF_ASSOCIATION_PROBABILITY_RANGE = new DoubleRange(2.5000000000000004E-7, 2.5E-5);
    public static final DoubleRange POLYMERASE_ASSOCIATION_PROBABILITY_RANGE = new DoubleRange(0.0, 1.9E-6);
    public static final DoubleRange PROTEIN_DEGRADATION_RANGE = new DoubleRange(2.7999999292660505E-4, 5.199999868636951E-4);
    public static final DoubleRange MRNA_DEGRADATION_RATE_RANGE = new DoubleRange(1.0E-5, 10.0);
    private final Random _random = new Random();
    private final int[] _objectCounts = new int[]{20, 2000, 5000, 0, 0, 0, 2000, 0, 0};
    private final double[] _reactionProbabilities = new double[]{2.5E-6, 9.0E-4f, 9.5E-7, 8.5E-4f, 0.003f, 0.001f, 9.0E-4f, 9.0E-4f, 4.0E-4f, 0.01};

    public CellProteinSynthesisSimulator(int n) {
        this._objectCounts[6] = n;
    }

    public void setTranscriptionFactorCount(int n) {
        assert (TRANSCRIPTION_FACTOR_COUNT_RANGE.contains(n));
        this._objectCounts[1] = n;
    }

    public void setGeneTranscriptionFactorAssociationRate(double d) {
        assert (TF_ASSOCIATION_PROBABILITY_RANGE.contains(d));
        this._reactionProbabilities[0] = d;
    }

    public void setPolymeraseAssociationRate(double d) {
        assert (POLYMERASE_ASSOCIATION_PROBABILITY_RANGE.contains(d));
        this._reactionProbabilities[2] = d;
    }

    public void setProteinDegradationRate(double d) {
        assert (PROTEIN_DEGRADATION_RANGE.contains(d));
        this._reactionProbabilities[8] = d;
    }

    public void setMrnaDegradationRate(double d) {
        assert (MRNA_DEGRADATION_RATE_RANGE.contains(d));
        this._reactionProbabilities[9] = d;
    }

    public void stepInTime(double d) {
        double d2 = -1.0;
        for (double d3 = 0.0; d3 < d && d2 != 0.0; d3 += d2) {
            d2 = this.simulateOneReaction(d - d3);
        }
    }

    double simulateOneReaction(double d) {
        double[] dArray = this.calculateA();
        double d2 = this.sum(dArray);
        double d3 = this._random.nextDouble();
        double d4 = this._random.nextDouble();
        double d5 = 1.0 / d2 * Math.log(1.0 / d3);
        if (d5 > d) {
            return 0.0;
        }
        int n = 0;
        for (double d6 = dArray[0]; d6 < d4 * d2; d6 += dArray[++n]) {
        }
        this.conductReaction(n);
        return d5;
    }

    private double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    private double[] calculateA() {
        double[] dArray = new double[this._reactionProbabilities.length];
        dArray[0] = this._objectCounts[0] * this._objectCounts[1];
        dArray[1] = this._objectCounts[3];
        dArray[2] = this._objectCounts[2] * this._objectCounts[3];
        dArray[3] = this._objectCounts[4];
        dArray[4] = this._objectCounts[4];
        dArray[5] = this._objectCounts[5] * this._objectCounts[6];
        dArray[6] = this._objectCounts[7];
        dArray[7] = this._objectCounts[7];
        dArray[8] = this._objectCounts[8];
        dArray[9] = this._objectCounts[5];
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] * this._reactionProbabilities[i];
        }
        return dArray;
    }

    private void conductReaction(int n) {
        switch (n) {
            case 0: {
                this._objectCounts[0] = this._objectCounts[0] - 1;
                this._objectCounts[1] = this._objectCounts[1] - 1;
                this._objectCounts[3] = this._objectCounts[3] + 1;
                break;
            }
            case 1: {
                this._objectCounts[0] = this._objectCounts[0] + 1;
                this._objectCounts[1] = this._objectCounts[1] + 1;
                this._objectCounts[3] = this._objectCounts[3] - 1;
                break;
            }
            case 2: {
                this._objectCounts[3] = this._objectCounts[3] - 1;
                this._objectCounts[2] = this._objectCounts[2] - 1;
                this._objectCounts[4] = this._objectCounts[4] + 1;
                break;
            }
            case 3: {
                this._objectCounts[3] = this._objectCounts[3] + 1;
                this._objectCounts[2] = this._objectCounts[2] + 1;
                this._objectCounts[4] = this._objectCounts[4] - 1;
                break;
            }
            case 4: {
                this._objectCounts[0] = this._objectCounts[0] + 1;
                this._objectCounts[1] = this._objectCounts[1] + 1;
                this._objectCounts[2] = this._objectCounts[2] + 1;
                this._objectCounts[4] = this._objectCounts[4] - 1;
                this._objectCounts[5] = this._objectCounts[5] + 1;
                break;
            }
            case 5: {
                this._objectCounts[5] = this._objectCounts[5] - 1;
                this._objectCounts[6] = this._objectCounts[6] - 1;
                this._objectCounts[7] = this._objectCounts[7] + 1;
                break;
            }
            case 6: {
                this._objectCounts[5] = this._objectCounts[5] + 1;
                this._objectCounts[6] = this._objectCounts[6] + 1;
                this._objectCounts[7] = this._objectCounts[7] - 1;
                break;
            }
            case 7: {
                this._objectCounts[6] = this._objectCounts[6] + 1;
                this._objectCounts[7] = this._objectCounts[7] - 1;
                this._objectCounts[8] = this._objectCounts[8] + 1;
                break;
            }
            case 8: {
                this._objectCounts[8] = this._objectCounts[8] - 1;
                break;
            }
            case 9: {
                this._objectCounts[5] = this._objectCounts[5] - 1;
            }
        }
    }

    public int getProteinCount() {
        return this._objectCounts[8];
    }
}

