/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.view;

import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class CollapsibleControlPanel
extends PNode {
    private final PNode controls;
    private final PNode titleBar;
    private final PNode titleBarSpacer;
    private double minWidth = 0.0;
    private final OpenCloseButton openCloseButton;

    public CollapsibleControlPanel(Color color, String string, Font font, final PNode pNode) {
        this.controls = pNode;
        this.openCloseButton = new OpenCloseButton(false);
        this.titleBar = new PNode();
        this.titleBar.addChild(new HBox(10.0, this.openCloseButton, new PhetPText(string, font)));
        this.titleBarSpacer = new PNode();
        this.titleBar.addChild(this.titleBarSpacer);
        final PNode pNode2 = new PNode();
        ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)new VBox(10.0, VBox.LEFT_ALIGNED, this.titleBar, pNode2), color, new BasicStroke(2.0f), Color.BLACK, 9);
        this.addChild(controlPanelNode);
        this.openCloseButton.open.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    pNode2.addChild(pNode);
                } else {
                    pNode2.removeAllChildren();
                }
            }
        });
        this.updateLayout();
    }

    public void setOpen(boolean bl) {
        this.openCloseButton.open.set(bl);
    }

    public PBounds getFullBoundsWhenOpen() {
        boolean bl = (Boolean)this.openCloseButton.open.get();
        if (!bl) {
            this.setOpen(true);
        }
        PBounds pBounds = this.getFullBounds();
        this.setOpen(bl);
        return pBounds;
    }

    public void setMinWidth(double d) {
        if (d != this.minWidth) {
            this.minWidth = d;
            this.updateLayout();
        }
    }

    private void updateLayout() {
        this.titleBarSpacer.removeAllChildren();
        this.controls.setOffset(0.0, 0.0);
        double d = Math.max(Math.max(this.controls.getFullBoundsReference().width, this.titleBar.getFullBoundsReference().width), this.minWidth - 18.0);
        if (this.titleBar.getFullBoundsReference().width < d) {
            this.titleBarSpacer.addChild(new HPad(d));
        }
        if (this.controls.getFullBoundsReference().width < d) {
            this.controls.setOffset(d / 2.0 - this.controls.getFullBoundsReference().width / 2.0, 0.0);
        }
    }

    private static class HPad
    extends PNode {
        private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);

        private HPad(double d) {
            this.addChild(new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, d, 0.01), (Paint)INVISIBLE_COLOR));
        }
    }

    private static class OpenCloseButton
    extends PNode {
        public final BooleanProperty open;
        private final PNode openButton = new PImage(PhetCommonResources.getMaximizeButtonImage());
        private final PNode closeButton = new PImage(PhetCommonResources.getMinimizeButtonImage());

        private OpenCloseButton(boolean bl) {
            this.addInputEventListener(new CursorHandler());
            this.addChild(this.openButton);
            this.addChild(this.closeButton);
            this.open = new BooleanProperty(bl);
            this.open.addObserver(new VoidFunction1<Boolean>(){

                @Override
                public void apply(Boolean bl) {
                    OpenCloseButton.this.openButton.setVisible(bl == false);
                    OpenCloseButton.this.closeButton.setVisible(bl);
                }
            });
            this.openButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseReleased(PInputEvent pInputEvent) {
                    OpenCloseButton.this.open.set(true);
                }
            });
            this.closeButton.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseReleased(PInputEvent pInputEvent) {
                    OpenCloseButton.this.open.set(false);
                }
            });
        }
    }
}

