/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.geneexpressionbasics.multiplecells.model.Cell;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class ColorChangingCellNode
extends PNode {
    public static final Color NOMINAL_FILL_COLOR = new Color(30, 30, 40);
    public static final Color FLORESCENT_FILL_COLOR = new Color(200, 255, 58);
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private static final Color STROKE_COLOR = Color.WHITE;

    public ColorChangingCellNode(Cell cell, ModelViewTransform modelViewTransform) {
        final PhetPPath phetPPath = new PhetPPath(modelViewTransform.modelToView(cell.getShape()), NOMINAL_FILL_COLOR, STROKE, STROKE_COLOR);
        cell.proteinCount.addObserver(new VoidFunction1<Integer>(){

            @Override
            public void apply(Integer n) {
                double d = MathUtil.clamp(0.0, ((double)n.intValue() - 50.0) / 100.0, 1.0);
                Color color = ColorUtils.interpolateRBGA(NOMINAL_FILL_COLOR, FLORESCENT_FILL_COLOR, d);
                phetPPath.setPaint(color);
            }
        });
        this.addChild(phetPPath);
    }
}

