/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class ImmutableVector2D
implements Serializable {
    private double x;
    private double y;
    public static final ImmutableVector2D ZERO = new ImmutableVector2D();

    public ImmutableVector2D() {
        this(0.0, 0.0);
    }

    public ImmutableVector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public ImmutableVector2D(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this.getClass() != object.getClass()) {
            bl = false;
        } else {
            ImmutableVector2D immutableVector2D = (ImmutableVector2D)object;
            bl = this.getX() == immutableVector2D.getX() && this.getY() == immutableVector2D.getY();
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName().replaceAll(".*\\.", "") + "[" + this.x + ", " + this.y + "]";
    }

    public ImmutableVector2D getNormalVector() {
        return new ImmutableVector2D(this.y, -this.x);
    }

    public ImmutableVector2D getNormalizedInstance() {
        double d = this.getMagnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return new ImmutableVector2D(this.getX() / d, this.getY() / d);
    }

    public ImmutableVector2D getSubtractedInstance(double d, double d2) {
        return new ImmutableVector2D(this.getX() - d, this.getY() - d2);
    }

    public ImmutableVector2D getSubtractedInstance(ImmutableVector2D immutableVector2D) {
        return this.getSubtractedInstance(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getMagnitudeSq() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSq());
    }

    protected void setComponents(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    protected void setX(double d) {
        this.x = d;
    }

    protected void setY(double d) {
        this.y = d;
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }
}

