/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.clock;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.SliderOnlyLayoutStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimSpeedControl
extends JPanel {
    private final LinearValueControl linearSlider;

    public SimSpeedControl(double d, double d2, ConstantDtClock constantDtClock, String string) {
        this(d, d2, constantDtClock, string, Color.BLACK);
    }

    public SimSpeedControl(double d, double d2, ConstantDtClock constantDtClock, String string, Color color) {
        this(d, d2, constantDtClock, string, new Property<Color>(color));
    }

    public SimSpeedControl(double d, double d2, final ConstantDtClock constantDtClock, String string, ObservableProperty<Color> observableProperty) {
        TimeSpeederLabel timeSpeederLabel = new TimeSpeederLabel(string, observableProperty);
        this.linearSlider = new LinearValueControl(d, d2, "", "", "", new SliderOnlyLayoutStrategy());
        Hashtable<Double, TimeSpeederLabel> hashtable = new Hashtable<Double, TimeSpeederLabel>();
        hashtable.put(new Double(d), new TimeSpeederLabel(PhetCommonResources.getString("Common.time.slow"), observableProperty));
        hashtable.put(new Double(d2), new TimeSpeederLabel(PhetCommonResources.getString("Common.time.fast"), observableProperty));
        this.linearSlider.setTickLabels(hashtable);
        constantDtClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                SimSpeedControl.this.update(constantDtClock);
            }
        });
        this.update(constantDtClock);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)timeSpeederLabel, gridBagConstraints);
        this.add((Component)this.linearSlider, gridBagConstraints);
        this.linearSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                constantDtClock.setDt(SimSpeedControl.this.getValue());
            }
        });
    }

    private void update(ConstantDtClock constantDtClock) {
        this.linearSlider.setValue(constantDtClock.getTimingStrategy().getSimulationTimeChangeForPausedClock());
    }

    public double getValue() {
        return this.linearSlider.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeSpeederLabel
    extends JLabel {
        public TimeSpeederLabel(String string, ObservableProperty<Color> observableProperty) {
            super(string);
            observableProperty.addObserver(new VoidFunction1<Color>(){

                @Override
                public void apply(Color color) {
                    TimeSpeederLabel.this.setForeground(color);
                }
            });
        }
    }
}

