/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class PhetRootPNode
extends PNode {
    private final PNode worldNode = new PNode();
    private final PNode screenNode = new PNode();

    public void addWorldChild(PNode pNode) {
        WorldNode worldNode = new WorldNode(pNode);
        worldNode.setTransform(this.worldNode.getTransform());
        this.addChild(worldNode);
    }

    public void addScreenChild(PNode pNode) {
        ScreenNode screenNode = new ScreenNode(pNode);
        screenNode.setTransform(this.screenNode.getTransform());
        this.addChild(screenNode);
    }

    public int indexOfChild(PNode pNode) {
        int n = super.indexOfChild(pNode);
        if (n < 0) {
            List list = this.getChildrenReference();
            for (int i = 0; i < list.size(); ++i) {
                PNode pNode2 = (PNode)list.get(i);
                if (!(pNode2 instanceof WrapperNode) || ((WrapperNode)pNode2).getWrappedNode() != pNode) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private ArrayList getChildren(Class clazz) {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            PNode pNode = this.getChild(i);
            if (!clazz.isAssignableFrom(pNode.getClass())) continue;
            arrayList.add(pNode);
        }
        return arrayList;
    }

    private ArrayList getWorldChildren() {
        return this.getChildren(WorldNode.class);
    }

    public void setWorldTransform(AffineTransform affineTransform) {
        this.worldNode.setTransform(affineTransform);
        this.updateWorldNodes();
    }

    protected void updateWorldNodes() {
        ArrayList arrayList = this.getWorldChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            PNode pNode = (PNode)arrayList.get(i);
            pNode.setTransform(this.worldNode.getTransformReference(true));
        }
    }

    public void worldToScreen(Point2D point2D) {
        this.worldNode.localToGlobal(point2D);
        this.screenNode.globalToLocal(point2D);
    }

    public void screenToWorld(Dimension2D dimension2D) {
        this.screenNode.localToGlobal(dimension2D);
        this.worldNode.globalToLocal(dimension2D);
    }

    private static class ScreenNode
    extends WrapperNode {
        public ScreenNode(PNode pNode) {
            super(pNode);
        }
    }

    private static class WorldNode
    extends WrapperNode {
        public WorldNode(PNode pNode) {
            super(pNode);
        }
    }

    private static abstract class WrapperNode
    extends PNode {
        private PNode node;

        public WrapperNode(PNode pNode) {
            this.node = pNode;
            this.addChild(pNode);
        }

        public PNode getWrappedNode() {
            return this.node;
        }
    }
}

