/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public class HTMLImageButtonNode
extends ButtonNode {
    private String text;
    protected BufferedImage image;
    private Font font;
    private TextPosition textPosition;
    private int imageTextGap;

    public HTMLImageButtonNode() {
        this(null, null);
    }

    public HTMLImageButtonNode(String string) {
        this(string, null);
    }

    public HTMLImageButtonNode(String string, BufferedImage bufferedImage) {
        super(string, new PNode(), new PNode());
        this.text = string;
        this.image = bufferedImage;
        this.font = new PhetFont(0, 14);
        this.textPosition = TextPosition.RIGHT;
        this.imageTextGap = 5;
        this.updateContent();
    }

    private void updateContent() {
        this.setContentNode(HTMLImageButtonNode.createContentNode(this.text, this.font, this.getForeground(), this.getDisabledForeground(), true, this.image, this.image, this.textPosition, this.imageTextGap));
        this.setDisabledContentNode(HTMLImageButtonNode.createContentNode(this.text, this.font, this.getForeground(), this.getDisabledForeground(), false, this.image, this.image, this.textPosition, this.imageTextGap));
    }

    public HTMLImageButtonNode(String string, PhetFont phetFont, Color color) {
        this(string);
        this.setFont(phetFont);
        this.setBackground(color);
    }

    public void setFont(Font font) {
        if (!font.equals(this.font)) {
            this.font = font;
            this.updateContent();
        }
    }

    private static PNode createTextNode(String string, Font font, Color color, Color color2, boolean bl) {
        PNode pNode = null;
        if (string != null) {
            HTMLNode hTMLNode = new HTMLNode(string, bl ? color : color2);
            hTMLNode.setFont(font);
            hTMLNode.setPickable(false);
            pNode = hTMLNode;
        } else {
            pNode = new PNode();
        }
        return pNode;
    }

    private static PNode createImageNode(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        PNode pNode = null;
        pNode = bufferedImage != null ? (bl ? new PImage(bufferedImage) : (bufferedImage2 != null ? new PImage(bufferedImage2) : new PImage(HTMLImageButtonNode.createGrayscaleImage(bufferedImage)))) : new PNode();
        return pNode;
    }

    private static BufferedImage createGrayscaleImage(BufferedImage bufferedImage) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
        return colorConvertOp.filter(bufferedImage, null);
    }

    private static PNode createContentNode(String string, Font font, Color color, Color color2, boolean bl, BufferedImage bufferedImage, BufferedImage bufferedImage2, TextPosition textPosition, double d) {
        double d2;
        double d3;
        PNode pNode = HTMLImageButtonNode.createTextNode(string, font, color, color2, bl);
        PNode pNode2 = HTMLImageButtonNode.createImageNode(bufferedImage, bufferedImage2, bl);
        PComposite pComposite = new PComposite();
        pComposite.addChild(pNode);
        pComposite.addChild(pNode2);
        double d4 = 0.0;
        double d5 = 0.0;
        PBounds pBounds = pNode.getFullBoundsReference();
        PBounds pBounds2 = pNode2.getFullBoundsReference();
        if (textPosition == TextPosition.ABOVE) {
            d3 = 0.0;
            d4 = pBounds.getCenterX() - pBounds2.getWidth() / 2.0;
            d2 = 0.0;
            d5 = pBounds.getMaxY() + d;
        } else if (textPosition == TextPosition.BELOW) {
            d4 = 0.0;
            d3 = pBounds2.getCenterX() - pBounds.getWidth() / 2.0;
            d5 = 0.0;
            d2 = pBounds2.getMaxY() + d;
        } else if (textPosition == TextPosition.LEFT) {
            d3 = 0.0;
            d4 = pBounds.getMaxX() + d;
            d2 = 0.0;
            d5 = pBounds.getCenterY() - pBounds2.getHeight() / 2.0;
        } else if (textPosition == TextPosition.RIGHT) {
            d4 = 0.0;
            d3 = pBounds2.getMaxX() + d;
            d5 = 0.0;
            d2 = pBounds2.getCenterY() - pBounds.getHeight() / 2.0;
        } else {
            throw new UnsupportedOperationException("unsupported text position: " + (Object)((Object)textPosition));
        }
        pNode.setOffset(d3, d2);
        pNode2.setOffset(d4, d5);
        return pComposite;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TextPosition
    extends Enum<TextPosition> {
        public static final /* enum */ TextPosition ABOVE = new TextPosition();
        public static final /* enum */ TextPosition BELOW = new TextPosition();
        public static final /* enum */ TextPosition LEFT = new TextPosition();
        public static final /* enum */ TextPosition RIGHT = new TextPosition();
        private static final /* synthetic */ TextPosition[] $VALUES;

        public static TextPosition[] values() {
            return (TextPosition[])$VALUES.clone();
        }

        static {
            $VALUES = new TextPosition[]{ABOVE, BELOW, LEFT, RIGHT};
        }
    }
}

