/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.controlpanel;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.NeuronStrings;
import edu.colorado.phet.neuron.model.PotassiumGatedChannel;
import edu.colorado.phet.neuron.model.PotassiumIon;
import edu.colorado.phet.neuron.model.PotassiumLeakageChannel;
import edu.colorado.phet.neuron.model.SodiumDualGatedChannel;
import edu.colorado.phet.neuron.model.SodiumIon;
import edu.colorado.phet.neuron.model.SodiumLeakageChannel;
import edu.colorado.phet.neuron.view.MembraneChannelNode;
import edu.colorado.phet.neuron.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class IonsAndChannelsLegendPanel
extends JPanel {
    private static final ModelViewTransform2D PARTICLE_MVT = new ModelViewTransform2D(new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0), new Rectangle2D.Double(-8.0, -8.0, 16.0, 16.0));
    private static final ModelViewTransform2D CHANNEL_MVT = new ModelViewTransform2D((Point2D)new Point2D.Double(), (Point2D)new Point2D.Double(), 7.0, false);

    public IonsAndChannelsLegendPanel() {
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NeuronStrings.LEGEND_TITLE, 1, 2, NeuronConstants.CONTROL_PANEL_TITLE_FONT, Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        int n = 0;
        PNode pNode = new ParticleNode(new SodiumIon(), PARTICLE_MVT);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_SODIUM_ION, n++);
        pNode = new ParticleNode(new PotassiumIon(), PARTICLE_MVT);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_POTASSIUM_ION, n++);
        pNode = new MembraneChannelNode(new SodiumDualGatedChannel(), CHANNEL_MVT);
        pNode.rotate(-1.5707963267948966);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_SODIUM_GATED_CHANNEL, n++);
        pNode = new MembraneChannelNode(new PotassiumGatedChannel(), CHANNEL_MVT);
        pNode.rotate(-1.5707963267948966);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_POTASSIUM_GATED_CHANNEL, n++);
        pNode = new MembraneChannelNode(new SodiumLeakageChannel(), CHANNEL_MVT);
        pNode.rotate(-1.5707963267948966);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_SODIUM_LEAK_CHANNEL, n++);
        pNode = new MembraneChannelNode(new PotassiumLeakageChannel(), CHANNEL_MVT);
        pNode.rotate(-1.5707963267948966);
        this.addLegendItem(pNode.toImage(), NeuronStrings.LEGEND_POTASSIUM_LEAK_CHANNEL, n++);
    }

    private void addLegendItem(Image image, String string, int n) {
        ImageIcon imageIcon = new ImageIcon(image);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.ipady = 10;
        this.add((Component)new JLabel(imageIcon), gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 1;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(NeuronConstants.CONTROL_PANEL_CONTROL_FONT);
        this.add((Component)jLabel, gridBagConstraints);
    }
}

