/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.developer;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class HodgkinHuxleyInternalDynamicsDlg
extends PaintImmediateDialog {
    private static final Font DISPLAY_FONT = new PhetFont(14);
    private IHodgkinHuxleyModel hodgkinHuxleyModel;
    private JLabel timeLabel = new JLabel("Time: ");
    private JTextField timeText = new JTextField("000.0000 ms");
    private JLabel voltageLabel = new JLabel("Membrane Voltage: ");
    private JTextField voltageText = new JTextField("00.0 mV");
    private JLabel soduimChannelCurrentLabel = new JLabel("Sodium Channel Current: ");
    private JTextField sodiumChannelCurrentValue = new JTextField("00.0 mA");
    private JLabel potassiumChannelCurrentLabel = new JLabel("Potassium Channel Current: ");
    private JTextField potassiumChannelCurrentValue = new JTextField("00.0 mA");
    private JLabel leakChannelCurrentLabel = new JLabel("Leak Channel: ");
    private JTextField leakChannelCurrentValue = new JTextField("00.0 mA");
    private JLabel n4Label = new JLabel("n4: ");
    private JTextField n4Value = new JTextField("0.00");
    private JLabel m3hLabel = new JLabel("m3h: ");
    private JTextField m3hValue = new JTextField("0.00");
    private JButton captureButton = new JButton();
    private boolean capturing = false;
    private double previousElapsedTime = 1000000.0;
    private ArrayList<HhDataCaptureEntry> captureData = new ArrayList();

    public HodgkinHuxleyInternalDynamicsDlg(Frame frame, IClock iClock, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(frame);
        this.hodgkinHuxleyModel = iHodgkinHuxleyModel;
        this.setTitle("Hodgkin-Huxley Model Internal Dynamics");
        this.setLayout(new GridLayout(8, 2));
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (HodgkinHuxleyInternalDynamicsDlg.this.isVisible()) {
                    HodgkinHuxleyInternalDynamicsDlg.this.update();
                }
            }
        });
        this.timeLabel.setFont(DISPLAY_FONT);
        this.add(this.timeLabel);
        this.timeText.setFont(DISPLAY_FONT);
        this.timeText.setEditable(false);
        this.add(this.timeText);
        this.voltageLabel.setFont(DISPLAY_FONT);
        this.add(this.voltageLabel);
        this.voltageText.setFont(DISPLAY_FONT);
        this.voltageText.setEditable(false);
        this.add(this.voltageText);
        this.soduimChannelCurrentLabel.setFont(DISPLAY_FONT);
        this.add(this.soduimChannelCurrentLabel);
        this.sodiumChannelCurrentValue.setFont(DISPLAY_FONT);
        this.sodiumChannelCurrentValue.setEditable(false);
        this.add(this.sodiumChannelCurrentValue);
        this.potassiumChannelCurrentLabel.setFont(DISPLAY_FONT);
        this.add(this.potassiumChannelCurrentLabel);
        this.potassiumChannelCurrentValue.setFont(DISPLAY_FONT);
        this.potassiumChannelCurrentValue.setEditable(false);
        this.add(this.potassiumChannelCurrentValue);
        this.leakChannelCurrentLabel.setFont(DISPLAY_FONT);
        this.add(this.leakChannelCurrentLabel);
        this.leakChannelCurrentValue.setFont(DISPLAY_FONT);
        this.leakChannelCurrentValue.setEditable(false);
        this.add(this.leakChannelCurrentValue);
        this.n4Label.setFont(DISPLAY_FONT);
        this.add(this.n4Label);
        this.n4Value.setFont(DISPLAY_FONT);
        this.n4Value.setEditable(false);
        this.add(this.n4Value);
        this.m3hLabel.setFont(DISPLAY_FONT);
        this.add(this.m3hLabel);
        this.m3hValue.setFont(DISPLAY_FONT);
        this.m3hValue.setEditable(false);
        this.add(this.m3hValue);
        this.add(this.captureButton);
        this.captureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HodgkinHuxleyInternalDynamicsDlg.this.capturing) {
                    HodgkinHuxleyInternalDynamicsDlg.this.displayCapturedData();
                    HodgkinHuxleyInternalDynamicsDlg.this.captureData.clear();
                }
                HodgkinHuxleyInternalDynamicsDlg.this.capturing = !HodgkinHuxleyInternalDynamicsDlg.this.capturing;
                HodgkinHuxleyInternalDynamicsDlg.this.updateCaptureButtonState();
            }
        });
        this.updateCaptureButtonState();
        this.pack();
    }

    private void update() {
        double d = this.hodgkinHuxleyModel.getElapsedTime();
        if (d != this.previousElapsedTime) {
            double d2 = this.hodgkinHuxleyModel.getMembraneVoltage() * 1000.0;
            double d3 = this.hodgkinHuxleyModel.get_na_current();
            double d4 = this.hodgkinHuxleyModel.get_k_current();
            double d5 = this.hodgkinHuxleyModel.get_l_current();
            double d6 = this.hodgkinHuxleyModel.get_n4();
            double d7 = this.hodgkinHuxleyModel.get_m3h();
            this.timeText.setText(String.format("%.4f ms", d));
            this.voltageText.setText(String.format("%.2f mV", d2));
            this.sodiumChannelCurrentValue.setText(String.format("%.2f mA", -d3));
            this.potassiumChannelCurrentValue.setText(String.format("%.2f mA", -d4));
            this.leakChannelCurrentValue.setText(String.format("%.2f mA", -d5));
            this.n4Value.setText(String.format("%.5f", d6));
            this.m3hValue.setText(String.format("%.5f", d7));
            if (this.capturing) {
                this.captureData.add(new HhDataCaptureEntry(d, d2, -d3, -d4, -d5, d6, d7));
            }
        }
        this.previousElapsedTime = d;
    }

    private void updateCaptureButtonState() {
        if (!this.capturing) {
            this.captureButton.setText("Start Capturing");
        } else {
            this.captureButton.setText("Stop Capturing");
        }
    }

    private void displayCapturedData() {
        JDialog jDialog = new JDialog((Dialog)this, true);
        JTextArea jTextArea = new JTextArea(this.captureData.size() + 1, 80);
        jTextArea.setEditable(false);
        jTextArea.append(HhDataCaptureEntry.getHeader());
        for (HhDataCaptureEntry hhDataCaptureEntry : this.captureData) {
            jTextArea.append(hhDataCaptureEntry.toString());
        }
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jDialog.add(jScrollPane);
        jDialog.setSize(new Dimension(500, 300));
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
    }

    private static class HhDataCaptureEntry {
        private final double elapsedTime;
        private final double membraneVoltage;
        private final double currentNa;
        private final double currentK;
        private final double currentLeak;
        private final double n4;
        private final double m3h;

        public HhDataCaptureEntry(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            this.elapsedTime = d;
            this.membraneVoltage = d2;
            this.currentNa = d3;
            this.currentK = d4;
            this.currentLeak = d5;
            this.n4 = d6;
            this.m3h = d7;
        }

        protected static String getHeader() {
            return "elapsedTime, membraneVoltage, currentNa, currentK, currentLeak, n4, m3h\n";
        }

        public String toString() {
            String string = new String();
            string = string + String.format("%.4f, ", this.elapsedTime);
            string = string + String.format("%.2f, ", this.membraneVoltage);
            string = string + String.format("%.2f, ", this.currentNa);
            string = string + String.format("%.2f, ", this.currentK);
            string = string + String.format("%.2f, ", this.currentLeak);
            string = string + String.format("%.5f, ", this.n4);
            string = string + String.format("%.5f, ", this.m3h);
            string = string + "\n";
            return string;
        }
    }
}

