/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.developer;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class HodgkinHuxleyInternalParamsDlg
extends PaintImmediateDialog {
    private IHodgkinHuxleyModel hodgkinHuxleyModel;
    private ParameterEntry membraneCapacitanceParmEntry = new ParameterEntry("Membrane Capacitance:", "mF");
    private ParameterEntry gNaParmEntry = new ParameterEntry("Sodium Chan Conductance:", "S");
    private ParameterEntry gKParmEntry = new ParameterEntry("Potassium Chan Conductance:", "S");
    private ParameterEntry gLParmEntry = new ParameterEntry("Leak Chan Conductance:", "S");
    private JButton readValuesButton = new JButton("Read Values");
    private JButton writeValuesButton = new JButton("Write Values");

    public HodgkinHuxleyInternalParamsDlg(Frame frame, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(frame);
        this.hodgkinHuxleyModel = iHodgkinHuxleyModel;
        this.setTitle("Hodgkin-Huxley Model Parameters");
        this.setLayout(new GridLayout(5, 3));
        this.add(this.membraneCapacitanceParmEntry.getLabel());
        this.add(this.membraneCapacitanceParmEntry.getField());
        this.add(this.membraneCapacitanceParmEntry.getUnits());
        this.add(this.gNaParmEntry.getLabel());
        this.add(this.gNaParmEntry.getField());
        this.add(this.gNaParmEntry.getUnits());
        this.add(this.gKParmEntry.getLabel());
        this.add(this.gKParmEntry.getField());
        this.add(this.gKParmEntry.getUnits());
        this.add(this.gLParmEntry.getLabel());
        this.add(this.gLParmEntry.getField());
        this.add(this.gLParmEntry.getUnits());
        this.add(this.readValuesButton);
        this.readValuesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HodgkinHuxleyInternalParamsDlg.this.readValuesFromModel();
            }
        });
        this.add(this.writeValuesButton);
        this.writeValuesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HodgkinHuxleyInternalParamsDlg.this.writeValuesToModel();
                HodgkinHuxleyInternalParamsDlg.this.readValuesFromModel();
            }
        });
        this.readValuesFromModel();
        this.pack();
    }

    private void readValuesFromModel() {
        this.membraneCapacitanceParmEntry.setValueText(String.format("%.6f", this.hodgkinHuxleyModel.getCm()));
        this.gNaParmEntry.setValueText(String.format("%.6f", this.hodgkinHuxleyModel.get_gna()));
        this.gKParmEntry.setValueText(String.format("%.6f", this.hodgkinHuxleyModel.get_gk()));
        this.gLParmEntry.setValueText(String.format("%.6f", this.hodgkinHuxleyModel.get_gl()));
    }

    private void writeValuesToModel() {
        this.hodgkinHuxleyModel.setCm(this.membraneCapacitanceParmEntry.getValue());
        this.hodgkinHuxleyModel.set_gna(this.gNaParmEntry.getValue());
        this.hodgkinHuxleyModel.set_gk(this.gKParmEntry.getValue());
        this.hodgkinHuxleyModel.set_gl(this.gLParmEntry.getValue());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.readValuesFromModel();
        }
        super.setVisible(bl);
    }

    private static class ParameterEntry {
        private static final Font LABEL_FONT = new PhetFont(14);
        private final JLabel label;
        private final JTextField field;
        private final JLabel units;

        public ParameterEntry(String string, String string2) {
            this.label = new JLabel(string);
            this.label.setFont(LABEL_FONT);
            this.field = new JTextField();
            this.field.setFont(LABEL_FONT);
            this.units = new JLabel(string2);
            this.units.setFont(LABEL_FONT);
        }

        protected JLabel getLabel() {
            return this.label;
        }

        protected JTextField getField() {
            return this.field;
        }

        protected JLabel getUnits() {
            return this.units;
        }

        protected void setValueText(String string) {
            this.field.setText(string);
        }

        protected double getValue() {
            return Double.parseDouble(this.field.getText());
        }
    }
}

