/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.view.graphics.ReversePathIterator;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class AxonMembrane {
    private ArrayList<Listener> listeners = new ArrayList();
    private Ellipse2D crossSectionEllipseShape = new Ellipse2D.Double(-75.0, -75.0, 150.0, 150.0);
    private Shape bodyShape = this.createAxonBodyShape();
    private TravelingActionPotential travelingActionPotential;
    private Point2D vanishingPoint;
    private Point2D intersectionPointA;
    private Point2D intersectionPointB;
    private Point2D cntrlPtA1;
    private Point2D cntrlPtA2;
    private Point2D cntrlPtB1;
    private Point2D cntrlPtB2;
    private CubicCurve2D curveA;
    private CubicCurve2D curveB;

    public Ellipse2D getCrossSectionEllipseShape() {
        return new Ellipse2D.Double(this.crossSectionEllipseShape.getX(), this.crossSectionEllipseShape.getY(), this.crossSectionEllipseShape.getWidth(), this.crossSectionEllipseShape.getHeight());
    }

    public double getMembraneThickness() {
        return 4.0;
    }

    public double getCrossSectionDiameter() {
        return 150.0;
    }

    public Shape getAxonBodyShape() {
        return this.bodyShape;
    }

    public CubicCurve2D getCurveA() {
        return this.curveA;
    }

    public CubicCurve2D getCurveB() {
        return this.curveB;
    }

    public AxonMembraneState getState() {
        if (this.travelingActionPotential == null) {
            return new AxonMembraneState(null);
        }
        return new AxonMembraneState(this.travelingActionPotential.getState());
    }

    public void setState(AxonMembraneState axonMembraneState) {
        if (axonMembraneState.getTravelingActionPotentialState() == null && this.travelingActionPotential != null) {
            this.removeTravelingActionPotential();
        } else if (axonMembraneState.getTravelingActionPotentialState() != null && this.travelingActionPotential == null) {
            this.initiateTravelingActionPotential();
        }
        if (this.travelingActionPotential != null) {
            this.travelingActionPotential.setState(axonMembraneState.getTravelingActionPotentialState());
        }
    }

    private Shape createAxonBodyShape() {
        GeneralPath generalPath = new GeneralPath();
        this.vanishingPoint = new Point2D.Double(225.0 * Math.cos(0.7853981633974483), 225.0 * Math.sin(0.7853981633974483));
        double d = this.getCrossSectionDiameter() / 2.0 + this.getMembraneThickness() / 2.0;
        double d2 = 2.199114857512855;
        this.intersectionPointA = new Point2D.Double(d * Math.cos(d2), d * Math.sin(d2));
        this.intersectionPointB = new Point2D.Double(d * Math.cos(d2 += Math.PI), d * Math.sin(d2));
        double d3 = Math.atan2(this.vanishingPoint.getY() - this.intersectionPointA.getY(), this.vanishingPoint.getX() - this.intersectionPointA.getX());
        double d4 = this.intersectionPointA.distance(this.vanishingPoint) * 0.33;
        this.cntrlPtA1 = new Point2D.Double(this.intersectionPointA.getX() + d4 * Math.cos(d3 + 0.15), this.intersectionPointA.getY() + d4 * Math.sin(d3 + 0.15));
        d4 = this.intersectionPointA.distance(this.vanishingPoint) * 0.67;
        this.cntrlPtA2 = new Point2D.Double(this.intersectionPointA.getX() + d4 * Math.cos(d3 - 0.5), this.intersectionPointA.getY() + d4 * Math.sin(d3 - 0.5));
        double d5 = Math.atan2(this.intersectionPointB.getY() - this.vanishingPoint.getY(), this.intersectionPointB.getX() - this.intersectionPointB.getX());
        d4 = this.intersectionPointB.distance(this.vanishingPoint) * 0.33;
        this.cntrlPtB1 = new Point2D.Double(this.vanishingPoint.getX() + d4 * Math.cos(d5 + 0.1), this.vanishingPoint.getY() + d4 * Math.sin(d5 + 0.1));
        d4 = this.intersectionPointB.distance(this.vanishingPoint) * 0.67;
        this.cntrlPtB2 = new Point2D.Double(this.vanishingPoint.getX() + d4 * Math.cos(d5 - 0.25), this.vanishingPoint.getY() + d4 * Math.sin(d5 - 0.25));
        this.curveA = new CubicCurve2D.Double(this.vanishingPoint.getX(), this.vanishingPoint.getY(), this.cntrlPtA2.getX(), this.cntrlPtA2.getY(), this.cntrlPtA1.getX(), this.cntrlPtA1.getY(), this.intersectionPointA.getX(), this.intersectionPointA.getY());
        this.curveB = new CubicCurve2D.Double(this.vanishingPoint.getX(), this.vanishingPoint.getY(), this.cntrlPtB1.getX(), this.cntrlPtB1.getY(), this.cntrlPtB2.getX(), this.cntrlPtB2.getY(), this.intersectionPointB.getX(), this.intersectionPointB.getY());
        generalPath.append(ReversePathIterator.getReversePathIterator(this.curveA), false);
        generalPath.append(this.curveB, false);
        generalPath.lineTo((float)this.intersectionPointA.getX(), (float)this.intersectionPointA.getY());
        return generalPath;
    }

    private static Point2D evaluateCurve(CubicCurve2D cubicCurve2D, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("t is out of range: " + d);
        }
        Point2D point2D = AxonMembrane.linearInterpolation(cubicCurve2D.getP1(), cubicCurve2D.getCtrlP1(), d);
        Point2D point2D2 = AxonMembrane.linearInterpolation(cubicCurve2D.getCtrlP1(), cubicCurve2D.getCtrlP2(), d);
        Point2D point2D3 = AxonMembrane.linearInterpolation(cubicCurve2D.getCtrlP2(), cubicCurve2D.getP2(), d);
        Point2D point2D4 = AxonMembrane.linearInterpolation(point2D, point2D2, d);
        Point2D point2D5 = AxonMembrane.linearInterpolation(point2D2, point2D3, d);
        return AxonMembrane.linearInterpolation(point2D4, point2D5, d);
    }

    private static Point2D linearInterpolation(Point2D point2D, Point2D point2D2, double d) {
        return new Point2D.Double(point2D.getX() + (point2D2.getX() - point2D.getX()) * d, point2D.getY() + (point2D2.getY() - point2D.getY()) * d);
    }

    public void initiateTravelingActionPotential() {
        this.travelingActionPotential = new TravelingActionPotential(this);
        this.travelingActionPotential.addListener(new TravelingActionPotential.Adapter(){

            public void crossSectionReached() {
                AxonMembrane.this.notifyTravelingActionPotentialReachedCrossSection();
            }

            public void lingeringCompleted() {
                AxonMembrane.this.removeTravelingActionPotential();
            }
        });
        this.notifyTravelingActionPotentialStarted();
    }

    private void removeTravelingActionPotential() {
        this.travelingActionPotential.removeAllListeners();
        this.travelingActionPotential = null;
        this.notifyTravelingActionPotentialEnded();
    }

    public TravelingActionPotential getTravelingActionPotential() {
        return this.travelingActionPotential;
    }

    public void reset() {
        if (this.travelingActionPotential != null) {
            this.removeTravelingActionPotential();
        }
    }

    public void stepInTime(double d) {
        if (this.travelingActionPotential != null) {
            this.travelingActionPotential.stepInTime(d);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyTravelingActionPotentialStarted() {
        for (Listener listener : this.listeners) {
            listener.travelingActionPotentialStarted();
        }
    }

    private void notifyTravelingActionPotentialReachedCrossSection() {
        for (Listener listener : this.listeners) {
            listener.travelingActionPotentialReachedCrossSection();
        }
    }

    private void notifyTravelingActionPotentialEnded() {
        for (Listener listener : this.listeners) {
            listener.travelingActionPotentialEnded();
        }
    }

    public static class Adapter
    implements Listener {
        public void travelingActionPotentialEnded() {
        }

        public void travelingActionPotentialReachedCrossSection() {
        }

        public void travelingActionPotentialStarted() {
        }
    }

    public class AxonMembraneState {
        private final TravelingActionPotential.TravelingActionPotentialState travelingActionPotentialState;

        public AxonMembraneState(TravelingActionPotential.TravelingActionPotentialState travelingActionPotentialState) {
            this.travelingActionPotentialState = travelingActionPotentialState;
        }

        protected TravelingActionPotential.TravelingActionPotentialState getTravelingActionPotentialState() {
            return this.travelingActionPotentialState;
        }
    }

    public static interface Listener {
        public void travelingActionPotentialStarted();

        public void travelingActionPotentialReachedCrossSection();

        public void travelingActionPotentialEnded();
    }

    public static class TravelingActionPotential {
        private static double TRAVELING_TIME = 0.002;
        private static double LINGER_AT_CROSS_SECTION_TIME = 5.0E-4;
        private ArrayList<Listener> listeners = new ArrayList();
        private double travelTimeCountdownTimer = TRAVELING_TIME;
        private double lingerCountdownTimer;
        private Shape shape;
        private AxonMembrane axonMembrane;

        public TravelingActionPotential(AxonMembrane axonMembrane) {
            this.axonMembrane = axonMembrane;
            this.updateShape();
        }

        public void stepInTime(double d) {
            if (this.travelTimeCountdownTimer > 0.0) {
                this.travelTimeCountdownTimer -= d;
                this.updateShape();
                if (this.travelTimeCountdownTimer <= 0.0) {
                    this.notifyCrossSectionReached();
                    this.lingerCountdownTimer = LINGER_AT_CROSS_SECTION_TIME;
                }
            } else if (this.lingerCountdownTimer > 0.0) {
                this.lingerCountdownTimer -= d;
                if (this.lingerCountdownTimer <= 0.0) {
                    this.shape = null;
                    this.notifyLingeringCompleted();
                } else {
                    this.updateShape();
                }
            }
        }

        public void setState(TravelingActionPotentialState travelingActionPotentialState) {
            this.travelTimeCountdownTimer = travelingActionPotentialState.getTravelTimeCountdownTimer();
            this.lingerCountdownTimer = travelingActionPotentialState.getLingerCountdownTimer();
            this.updateShape();
        }

        public TravelingActionPotentialState getState() {
            return new TravelingActionPotentialState(this.travelTimeCountdownTimer, this.lingerCountdownTimer);
        }

        private void updateShape() {
            if (this.travelTimeCountdownTimer > 0.0) {
                double d = 1.0 - this.travelTimeCountdownTimer / TRAVELING_TIME;
                Point2D point2D = AxonMembrane.evaluateCurve(this.axonMembrane.getCurveA(), d);
                Point2D point2D2 = AxonMembrane.evaluateCurve(this.axonMembrane.getCurveB(), d);
                Point2D.Double double_ = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
                double d2 = point2D2.distance(point2D) * 0.7 * Math.pow(d, 1.8);
                double d3 = point2D2.distance(point2D) * 0.7 * Math.pow(d, 0.8);
                double d4 = Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX()) + 1.5707963267948966;
                Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() + d2 * Math.cos(d4 + 0.5235987755982988), ((Point2D)double_).getY() + d2 * Math.sin(d4 + 0.5235987755982988));
                Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() + d3 * Math.cos(d4 - 0.5235987755982988), ((Point2D)double_).getY() + d3 * Math.sin(d4 - 0.5235987755982988));
                this.shape = new CubicCurve2D.Double(point2D.getX(), point2D.getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY(), ((Point2D)double_3).getX(), ((Point2D)double_3).getY(), point2D2.getX(), point2D2.getY());
            } else {
                Ellipse2D ellipse2D = this.axonMembrane.getCrossSectionEllipseShape();
                double d = (1.0 - Math.abs(this.lingerCountdownTimer / LINGER_AT_CROSS_SECTION_TIME - 0.5) * 2.0) * 0.04 + 1.0;
                double d5 = ellipse2D.getWidth() * d;
                double d6 = ellipse2D.getHeight() * d;
                this.shape = new Ellipse2D.Double(-d5 / 2.0, -d6 / 2.0, d5, d6);
            }
            this.notifyShapeChanged();
        }

        public Shape getShape() {
            return this.shape;
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void removeAllListeners() {
            this.listeners.clear();
        }

        private void notifyLingeringCompleted() {
            ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
            for (Listener listener : arrayList) {
                listener.lingeringCompleted();
            }
        }

        private void notifyCrossSectionReached() {
            ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
            for (Listener listener : arrayList) {
                listener.crossSectionReached();
            }
        }

        private void notifyShapeChanged() {
            ArrayList<Listener> arrayList = new ArrayList<Listener>(this.listeners);
            for (Listener listener : arrayList) {
                listener.shapeChanged();
            }
        }

        public static class Adapter
        implements Listener {
            public void shapeChanged() {
            }

            public void crossSectionReached() {
            }

            public void lingeringCompleted() {
            }
        }

        public static interface Listener {
            public void shapeChanged();

            public void crossSectionReached();

            public void lingeringCompleted();
        }

        public static class TravelingActionPotentialState {
            private final double travelTimeCountdownTimer;
            private final double lingerCountdownTimer;

            public TravelingActionPotentialState(double d, double d2) {
                this.travelTimeCountdownTimer = d;
                this.lingerCountdownTimer = d2;
            }

            protected double getLingerCountdownTimer() {
                return this.lingerCountdownTimer;
            }

            protected double getTravelTimeCountdownTimer() {
                return this.travelTimeCountdownTimer;
            }
        }
    }
}

