/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.CaptureZone;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.MembraneChannelTypes;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.NullCaptureZone;
import edu.colorado.phet.neuron.model.Particle;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PotassiumGatedChannel;
import edu.colorado.phet.neuron.model.PotassiumLeakageChannel;
import edu.colorado.phet.neuron.model.SodiumDualGatedChannel;
import edu.colorado.phet.neuron.model.SodiumLeakageChannel;
import edu.colorado.phet.neuron.model.TraverseChannelAndFadeMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

public abstract class MembraneChannel {
    protected static final Random RAND = new Random();
    private IParticleCapture modelContainingParticles;
    private Point2D centerLocation = new Point2D.Double();
    private double rotationalAngle = 0.0;
    private Dimension2D channelSize = new PDimension();
    private Dimension2D overallSize = new PDimension();
    private double openness = 0.0;
    private double inactivationAmt = 0.0;
    private ArrayList<Listener> listeners = new ArrayList();
    private CaptureZone interiorCaptureZone = new NullCaptureZone();
    private CaptureZone exteriorCaptureZone = new NullCaptureZone();
    private double captureCountdownTimer = Double.POSITIVE_INFINITY;
    private double minInterCaptureTime = Double.POSITIVE_INFINITY;
    private double maxInterCaptureTime = Double.POSITIVE_INFINITY;
    private double particleVelocity = 40000.0;

    public MembraneChannel(double d, double d2, IParticleCapture iParticleCapture) {
        this.channelSize.setSize(d, d2);
        this.overallSize.setSize(d * 2.1, d2 * 1.3);
        this.modelContainingParticles = iParticleCapture;
    }

    public static MembraneChannel createMembraneChannel(MembraneChannelTypes membraneChannelTypes, IParticleCapture iParticleCapture, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        MembraneChannel membraneChannel = null;
        switch (membraneChannelTypes) {
            case SODIUM_LEAKAGE_CHANNEL: {
                membraneChannel = new SodiumLeakageChannel(iParticleCapture, iHodgkinHuxleyModel);
                break;
            }
            case SODIUM_GATED_CHANNEL: {
                membraneChannel = new SodiumDualGatedChannel(iParticleCapture, iHodgkinHuxleyModel);
                break;
            }
            case POTASSIUM_LEAKAGE_CHANNEL: {
                membraneChannel = new PotassiumLeakageChannel(iParticleCapture, iHodgkinHuxleyModel);
                break;
            }
            case POTASSIUM_GATED_CHANNEL: {
                membraneChannel = new PotassiumGatedChannel(iParticleCapture, iHodgkinHuxleyModel);
            }
        }
        assert (membraneChannel != null);
        return membraneChannel;
    }

    protected abstract ParticleType getParticleTypeToCapture();

    public void reset() {
        this.captureCountdownTimer = Double.POSITIVE_INFINITY;
    }

    protected boolean isOpen() {
        return this.getOpenness() > 0.2 && this.getInactivationAmt() < 0.7;
    }

    public boolean isPointInChannel(Point2D point2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.centerLocation.getX() - this.channelSize.getHeight() / 2.0, this.centerLocation.getY() - this.channelSize.getWidth() / 2.0, this.channelSize.getHeight(), this.channelSize.getWidth());
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.rotationalAngle, this.centerLocation.getX(), this.centerLocation.getY());
        Shape shape = affineTransform.createTransformedShape(double_);
        return shape.contains(point2D);
    }

    public boolean getHasInactivationGate() {
        return false;
    }

    public void stepInTime(double d) {
        if (this.captureCountdownTimer != Double.POSITIVE_INFINITY) {
            if (this.isOpen()) {
                this.captureCountdownTimer -= d;
                if (this.captureCountdownTimer <= 0.0) {
                    this.modelContainingParticles.requestParticleThroughChannel(this.getParticleTypeToCapture(), this, this.particleVelocity, this.chooseCrossingDirection());
                    this.restartCaptureCountdownTimer(false);
                }
            } else {
                this.captureCountdownTimer = Double.POSITIVE_INFINITY;
            }
        }
    }

    public void moveParticleThroughNeuronMembrane(Particle particle, double d) {
        particle.setMotionStrategy(new TraverseChannelAndFadeMotionStrategy(this, particle.getPositionReference(), d));
    }

    protected void setParticleVelocity(double d) {
        this.particleVelocity = d;
    }

    protected void restartCaptureCountdownTimer(boolean bl) {
        if (this.minInterCaptureTime != Double.POSITIVE_INFINITY && this.maxInterCaptureTime != Double.POSITIVE_INFINITY) {
            assert (this.maxInterCaptureTime >= this.minInterCaptureTime);
            this.captureCountdownTimer = this.minInterCaptureTime + RAND.nextDouble() * (this.maxInterCaptureTime - this.minInterCaptureTime);
        } else {
            this.captureCountdownTimer = Double.POSITIVE_INFINITY;
        }
        if (bl) {
            this.modelContainingParticles.requestParticleThroughChannel(this.getParticleTypeToCapture(), this, this.particleVelocity, this.chooseCrossingDirection());
        }
    }

    public CaptureZone getInteriorCaptureZone() {
        return this.interiorCaptureZone;
    }

    protected void setInteriorCaptureZone(CaptureZone captureZone) {
        this.interiorCaptureZone = captureZone;
    }

    public CaptureZone getExteriorCaptureZone() {
        return this.exteriorCaptureZone;
    }

    protected void setExteriorCaptureZone(CaptureZone captureZone) {
        this.exteriorCaptureZone = captureZone;
    }

    public Dimension2D getChannelSize() {
        return new PDimension(this.channelSize);
    }

    public Point2D getCenterLocation() {
        return new Point2D.Double(this.centerLocation.getX(), this.centerLocation.getY());
    }

    public void setCenterLocation(Point2D point2D) {
        if (!point2D.equals(this.centerLocation)) {
            this.centerLocation.setLocation(point2D);
            this.interiorCaptureZone.setOriginPoint(point2D);
            this.exteriorCaptureZone.setOriginPoint(point2D);
            this.notifyPositionChanged();
        }
    }

    public void setRotationalAngle(double d) {
        this.rotationalAngle = d;
        this.interiorCaptureZone.setRotationalAngle(d);
        this.exteriorCaptureZone.setRotationalAngle(d);
    }

    public double getRotationalAngle() {
        return this.rotationalAngle;
    }

    public Dimension2D getOverallSize() {
        return this.overallSize;
    }

    public double getOpenness() {
        return this.openness;
    }

    protected void setOpenness(double d) {
        if (this.openness != d) {
            this.openness = d;
            this.notifyOpennessChanged();
        }
    }

    public double getInactivationAmt() {
        return this.inactivationAmt;
    }

    protected void setInactivationAmt(double d) {
        if (this.inactivationAmt != d) {
            this.inactivationAmt = d;
            this.notifyInactivationAmtChanged();
        }
    }

    public Color getChannelColor() {
        return Color.MAGENTA;
    }

    public Color getEdgeColor() {
        return Color.RED;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected abstract MembraneCrossingDirection chooseCrossingDirection();

    private void notifyOpennessChanged() {
        for (Listener listener : this.listeners) {
            listener.opennessChanged();
        }
    }

    private void notifyInactivationAmtChanged() {
        for (Listener listener : this.listeners) {
            listener.inactivationAmtChanged();
        }
    }

    private void notifyPositionChanged() {
        for (Listener listener : this.listeners) {
            listener.positionChanged();
        }
    }

    protected double getMaxInterCaptureTime() {
        return this.maxInterCaptureTime;
    }

    protected void setMaxInterCaptureTime(double d) {
        this.maxInterCaptureTime = d;
    }

    protected void setMinInterCaptureTime(double d) {
        this.minInterCaptureTime = d;
    }

    protected double getCaptureCountdownTimer() {
        return this.captureCountdownTimer;
    }

    public MembraneChannelState getState() {
        return new MembraneChannelState(this);
    }

    public void setState(MembraneChannelState membraneChannelState) {
        this.setOpenness(membraneChannelState.getOpenness());
        this.setInactivationAmt(membraneChannelState.getInactivationAmt());
    }

    public static class Adapter
    implements Listener {
        public void opennessChanged() {
        }

        public void inactivationAmtChanged() {
        }

        public void positionChanged() {
        }
    }

    public static interface Listener {
        public void opennessChanged();

        public void inactivationAmtChanged();

        public void positionChanged();
    }

    public static class MembraneChannelState {
        private final double openness;
        private final double inactivationAmt;

        public MembraneChannelState(MembraneChannel membraneChannel) {
            this.openness = membraneChannel.getOpenness();
            this.inactivationAmt = membraneChannel.getInactivationAmt();
        }

        public double getOpenness() {
            return this.openness;
        }

        public double getInactivationAmt() {
            return this.inactivationAmt;
        }
    }
}

